/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.perforce;

import com.perforce.p4java.server.IServer;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.ScmOptions;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.scm.impl.perforce.IPerforceClient;
import com.smartbear.scm.impl.perforce.P4JavaClient;
import com.smartbear.scm.impl.perforce.PerforceChangelist;
import com.smartbear.scm.impl.perforce.PerforceClientConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class PerforcePluginUtils {
    public static IScmOptions getOptions(IP4Connection connection) throws CoreException {
        IServer server = connection.getServer();
        ConnectionParameters params = connection.getParameters();
        ScmOptions options = new ScmOptions();
        options.setScm("perforce");
        options.setP4User(params.getUser());
        options.setP4Client(params.getClient());
        options.setP4Port(params.getPort());
        if (params.savePassword()) {
            options.setP4Passwd(params.getPassword());
        } else {
            String authTicket = server.getAuthTicket();
            options.setP4Passwd(authTicket);
        }
        return options;
    }

    public static PerforceClientConfiguration getClientConfig(IScmOptions options, IP4Connection connection) throws CoreException {
        try {
            return new PerforceClientConfiguration((IPerforceClient)P4JavaClient.create((IServer)connection.getServer(), (String)options.getP4Port(), (String)options.getP4Passwd(), (boolean)false, (IProgressMonitor)new NullProgressMonitor()));
        }
        catch (CollabClientException e) {
            CollaboratorUI.log((String)("Could not get Perforce config with options: " + options.toString()), (Throwable)e);
            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", 0, "Error configuring Perforce", (Throwable)e));
        }
    }

    public static IStructuredSelection convertInitialSelection(PerforceClientConfiguration clientConfig, IStructuredSelection p4Selection) throws CoreException {
        List p4Changelists = p4Selection.toList();
        ArrayList<PerforceChangelist> sbChangelists = new ArrayList<PerforceChangelist>(p4Selection.size());
        for (IP4Changelist p4Changelist : p4Changelists) {
            try {
                sbChangelists.add(clientConfig.getChangelist(Integer.toString(p4Changelist.getId()), (IProgressMonitor)new NullProgressMonitor()));
            }
            catch (ScmCommunicationException e) {
                throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.ui", 0, "Error loading changelist " + p4Changelist.getId(), (Throwable)e));
            }
        }
        return new StructuredSelection(sbChangelists);
    }
}

