/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc;

import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewInfo;
import com.smartbear.util.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class RtcUtil {
    public static URI computeReviewURI(ReviewInfo review, URL externalUrl) throws CollabClientException {
        StringBuilder uri = new StringBuilder();
        String urlStr = "";
        if (externalUrl != null) {
            urlStr = externalUrl.toString().replaceAll("/$", "");
        }
        uri.append(urlStr).append("/go?");
        uri.append(Strings.urlEncode((String)"page")).append('=').append(Strings.urlEncode((String)"ReviewDisplay"));
        uri.append("&").append(Strings.urlEncode((String)"reviewid")).append('=').append(Strings.urlEncode((String)review.getReviewId().toString()));
        try {
            return new URI(uri.toString());
        }
        catch (URISyntaxException e) {
            throw new CollabClientException("Unexpectedly Malformed URI", (Throwable)e);
        }
    }
}

