/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc;

import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.rtc.IRtcClientConfiguration;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.IScmCommitInfo;
import com.smartbear.scm.IScmVersion;
import com.smartbear.scm.ScmCommitInfoSimple;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class RtcVersion
implements IScmVersion {
    final IRtcClientConfiguration config;
    final IScmCommitInfo commitInfo;
    final String path;
    final IVersionableHandle version;
    RtcVersion pred;
    Logger LOGGER = Logger.getLogger(RtcVersion.class.getName());

    RtcVersion(IRtcClientConfiguration config, IScmCommitInfo commitInfo, String path, IVersionableHandle version, RtcVersion pred) {
        this.config = config;
        this.commitInfo = commitInfo;
        this.path = path;
        this.version = version;
        this.pred = pred;
    }

    public void setPred(RtcVersion pred) {
        this.pred = pred;
    }

    public IVersionableHandle getVersionable() {
        return this.version;
    }

    public IScmClientConfiguration getClientConfiguration() {
        return this.config;
    }

    public IScmCommitInfo getCommitInfo(IProgressMonitor monitor) throws ScmCommunicationException {
        return this.commitInfo;
    }

    public byte[] getContent(int maxContentSize, IProgressMonitor monitor) throws ScmCommunicationException {
        if (this.version == null) {
            return null;
        }
        return this.config.fetchContent(this.version, monitor);
    }

    public String getDepotPath() {
        return this.path;
    }

    public String getFullyQualifiedVersion() {
        return this.getVersion();
    }

    public List<IScmVersion> getHistory(int numVersions, IProgressMonitor monitor) throws ScmCommunicationException {
        ArrayList<IScmVersion> history = new ArrayList<IScmVersion>();
        history.add(this);
        if (numVersions == 1 || this.pred == null) {
            return history;
        }
        if (numVersions == 2) {
            history.add(this.pred);
            return history;
        }
        try {
            List changeHistory = this.config.getHistoryForVersionable(this.version, numVersions);
            IVersionableHandle beforeStateVersion = this.pred.getVersionable();
            block2: for (int index = 1; index < changeHistory.size(); ++index) {
                Object histObj = changeHistory.get(index);
                if (!(histObj instanceof IChangeHistoryEntryChange)) continue;
                IChangeHistoryEntryChange changeHistoryEntry = (IChangeHistoryEntryChange)histObj;
                IChangeSetHandle changeSetHandle = changeHistoryEntry.changeSet();
                IChangeSet changeSet = this.config.fetchChangeSet(changeSetHandle);
                for (Object changeObj : changeSet.changes()) {
                    IChange change;
                    IVersionableHandle afterStateVersion;
                    if (!(changeObj instanceof IChange) || !(afterStateVersion = (change = (IChange)changeObj).afterState()).sameItemId((IItemHandle)beforeStateVersion)) continue;
                    ScmCommitInfoSimple info = new ScmCommitInfoSimple();
                    IContributor author = this.config.fetchContributor(changeSet.getAuthor(), (IProgressMonitor)new NullProgressMonitor());
                    info.setAuthor(author.getName());
                    info.setComment(changeSet.getComment());
                    info.setDate(changeSet.getLastChangeDate());
                    info.setState(IScmCommitInfo.State.CONTROLLED);
                    info.setAtomicTransactionId(changeSet.getItemId().getUuidValue());
                    history.add(new RtcVersion(this.config, (IScmCommitInfo)info, this.path, afterStateVersion, null));
                    beforeStateVersion = change.beforeState();
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, "Error while fetching changeset history for version " + this.path, e);
        }
        return history;
    }

    public File getLocalPath() {
        return null;
    }

    public String getVersion() {
        if (this.version == null || this.commitInfo.getState() == IScmCommitInfo.State.DELETING) {
            return "";
        }
        return this.version.getStateId().getUuidValue();
    }

    public boolean isLocalVersion() {
        return false;
    }
}

