/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IVersionableHandle;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.rtc.IRtcClientConfiguration;
import com.smartbear.collaborator.rtc.RtcVersion;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.IScmCommitInfo;
import com.smartbear.scm.IScmVersion;
import com.smartbear.scm.ScmCommitInfoSimple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public final class RtcVersionFactory {
    private static final IProgressMonitor NO_MONITOR = new NullProgressMonitor();

    public static List<IScmVersion> loadVersions(IRtcClientConfiguration config, IScmChangelist changeSet, IChange change, String path, String previousPath) throws ScmCommunicationException {
        ArrayList<IScmVersion> versions = new ArrayList<IScmVersion>();
        if (change.afterState() == null && change.beforeState() == null) {
            return versions;
        }
        IScmCommitInfo.State state = RtcVersionFactory.getState(change);
        ScmCommitInfoSimple commitInfo = new ScmCommitInfoSimple(changeSet.getCommitInfo());
        commitInfo.setState(state);
        IFileItem after = RtcVersionFactory.fetchFileItem(config, change.afterState());
        if (after != null) {
            commitInfo.setDate(after.getFileTimestamp());
        }
        RtcVersion pred = null;
        if (change.beforeState() != null) {
            ScmCommitInfoSimple predCommitInfo = new ScmCommitInfoSimple(changeSet.getCommitInfo());
            IFileItem previousFile = RtcVersionFactory.getPreviousFile(config, change);
            predCommitInfo.setDate(previousFile.getFileTimestamp());
            predCommitInfo.setComment("");
            IContributor author = config.fetchContributor(previousFile.getModifiedBy(), NO_MONITOR);
            predCommitInfo.setAuthor(author.getUserId());
            predCommitInfo.setState(IScmCommitInfo.State.CONTROLLED);
            pred = new RtcVersion(config, (IScmCommitInfo)predCommitInfo, previousPath, (IVersionableHandle)previousFile, null);
            if (RtcVersionFactory.isRename(change)) {
                ScmCommitInfoSimple movedInfo = new ScmCommitInfoSimple(commitInfo);
                movedInfo.setState(IScmCommitInfo.State.DELETING);
                versions.add(new RtcVersion(config, (IScmCommitInfo)movedInfo, previousPath, null, pred));
            }
        }
        if (path == null) {
            path = previousPath;
        }
        RtcVersion current = new RtcVersion(config, (IScmCommitInfo)commitInfo, path, change.afterState(), pred);
        versions.add(current);
        return versions;
    }

    private static IScmCommitInfo.State getState(IChange change) {
        if (RtcVersionFactory.isRename(change)) {
            return IScmCommitInfo.State.ADDING;
        }
        if ((change.kind() & 1) != 0) {
            return IScmCommitInfo.State.ADDING;
        }
        if ((change.kind() & 0x10) != 0) {
            return IScmCommitInfo.State.DELETING;
        }
        return IScmCommitInfo.State.CONTROLLED;
    }

    private static boolean isRename(IChange change) {
        return (change.kind() & 0xC) != 0;
    }

    private static IFileItem getPreviousFile(IRtcClientConfiguration config, IChange change) throws ScmCommunicationException {
        if (change.beforeState() == null) {
            return null;
        }
        ArrayList<IFileItem> versions = new ArrayList<IFileItem>();
        versions.add(RtcVersionFactory.fetchFileItem(config, change.beforeState()));
        List mergeStates = change.mergeStates();
        if (mergeStates != null && !mergeStates.isEmpty()) {
            for (Object mergeState : mergeStates) {
                if (!(mergeState instanceof IVersionableHandle)) continue;
                versions.add(RtcVersionFactory.fetchFileItem(config, (IVersionableHandle)mergeState));
            }
        }
        if (versions.isEmpty()) {
            return null;
        }
        Collections.sort(versions, new Comparator<IFileItem>(){

            @Override
            public int compare(IFileItem o1, IFileItem o2) {
                return -o1.getFileTimestamp().compareTo(o2.getFileTimestamp());
            }
        });
        return (IFileItem)versions.get(0);
    }

    private static IFileItem fetchFileItem(IRtcClientConfiguration config, IVersionableHandle handle) throws ScmCommunicationException {
        if (handle == null) {
            return null;
        }
        return config.fetchFileItem(handle, NO_MONITOR);
    }
}

