/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.subversive;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collections.ClosureReturn;
import com.smartbear.progress.IteratorWithProgress;
import com.smartbear.progress.OutputStreamWithProgress;
import com.smartbear.scm.impl.subversion.AbstractSubversionClient;
import com.smartbear.scm.impl.subversion.IPathState;
import com.smartbear.scm.impl.subversion.ISubversionClient;
import com.smartbear.scm.impl.subversion.Info;
import com.smartbear.scm.impl.subversion.ListEntry;
import com.smartbear.scm.impl.subversion.LogEntry;
import com.smartbear.scm.impl.subversion.LogPath;
import com.smartbear.scm.impl.subversion.StatusEntry;
import com.smartbear.scm.impl.subversion.SubversionAccessForbiddenException;
import com.smartbear.scm.impl.subversion.SubversionNoSuchRevisionException;
import com.smartbear.scm.impl.subversion.SubversionNotVersionedResourceException;
import com.smartbear.scm.impl.subversion.SubversionNotWorkingCopyException;
import com.smartbear.util.NumberUtils;
import com.smartbear.util.Strings;
import com.smartbear.util.UtcDateUtils;
import com.smartbear.util.commons.ArrayUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryInfoCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNLogEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;

public class SVNConnectorSubversionClient
extends AbstractSubversionClient
implements ISubversionClient {
    private static final int CAT_BUFFER_SIZE = 2048;
    private static final String[] LOG_REVPROPS = new String[]{"svn:author", "svn:date", "svn:log"};
    private final IRepositoryLocation location;

    public SVNConnectorSubversionClient(IRepositoryLocation location) {
        this.location = location;
    }

    public String getVersionInfo(IProgressMonitor monitor) throws ScmCommunicationException {
        return this.run(new ISVNConnectorOperation<String>(){

            @Override
            public String run(ISVNConnector connector) throws SVNConnectorException {
                return "SVN Connector " + connector + " (" + connector.getClass() + ")";
            }
        }, null);
    }

    private static void info(ISVNConnector connector, SVNEntryRevisionReference revisionRef, SVNDepth depth, ISVNEntryInfoCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        connector.getInfo(revisionRef, depth, 0L, null, callback, monitor);
    }

    private static void logEntries(ISVNConnector connector, SVNEntryReference ref, SVNRevisionRange[] range, long limit, long options, ISVNLogEntryCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        connector.listHistoryLog(ref, range, LOG_REVPROPS, limit, options, callback, monitor);
    }

    private static void list(ISVNConnector connector, SVNEntryRevisionReference ref, SVNDepth depth, int kind, ISVNEntryCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        connector.listEntries(ref, depth, kind, 0L, callback, monitor);
    }

    private static int getDepth(String depth) {
        Class<?> depthClass;
        try {
            depthClass = Class.forName("org.eclipse.team.svn.core.connector.SVNDepth");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            Field f = depthClass.getDeclaredField(depth);
            return f.getInt(depthClass);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Info info(File file, IProgressMonitor monitor) throws ScmCommunicationException, SubversionNotWorkingCopyException {
        return this.info(new SVNEntryRevisionReference(file.getPath()), file, monitor);
    }

    public Info info(String url, String pegRevision, String opRevision, IProgressMonitor monitor) throws ScmCommunicationException {
        return this.info(new SVNEntryRevisionReference(url, SVNRevision.fromString((String)pegRevision), SVNRevision.fromString((String)opRevision)), null, monitor);
    }

    private Info info(final SVNEntryRevisionReference revisionRef, final File file, IProgressMonitor monitor) throws ScmCommunicationException {
        return this.run(new ISVNConnectorOperation<Info>(){

            @Override
            public Info run(ISVNConnector connector) throws SVNConnectorException {
                final ClosureReturn info = new ClosureReturn();
                SVNConnectorSubversionClient.info(connector, revisionRef, SVNDepth.EMPTY, new ISVNEntryInfoCallback(){

                    public void next(SVNEntryInfo subversiveInfo) {
                        info.set((Object)SVNConnectorSubversionClient.this.toInfo(subversiveInfo, file));
                    }
                }, (ISVNProgressMonitor)new SVNNullProgressMonitor());
                return (Info)info.get();
            }
        }, file);
    }

    protected static IPathState.NodeKind toNodeKind(int nodeKind) {
        SVNEntry.Kind kind = SVNEntry.Kind.fromId((int)nodeKind);
        if (kind == SVNEntry.Kind.DIR) {
            return IPathState.NodeKind.DIRECTORY;
        }
        if (kind == SVNEntry.Kind.FILE) {
            return IPathState.NodeKind.FILE;
        }
        if (kind == SVNEntry.Kind.NONE) {
            return IPathState.NodeKind.NONE;
        }
        if (kind == SVNEntry.Kind.UNKNOWN) {
            return IPathState.NodeKind.UNKNOWN;
        }
        throw new RuntimeException("Unrecognized node kind: " + nodeKind);
    }

    protected static IPathState.NodeKind toNodeKind2(SVNEntry.Kind kind) {
        if (kind == SVNEntry.Kind.DIR) {
            return IPathState.NodeKind.DIRECTORY;
        }
        if (kind == SVNEntry.Kind.FILE) {
            return IPathState.NodeKind.FILE;
        }
        if (kind == SVNEntry.Kind.NONE) {
            return IPathState.NodeKind.NONE;
        }
        if (kind == SVNEntry.Kind.UNKNOWN) {
            return IPathState.NodeKind.UNKNOWN;
        }
        throw new RuntimeException("Unrecognized node kind: ");
    }

    private Info toInfo(SVNEntryInfo info, File file) {
        String fileName = FilenameUtils.getName((String)info.path);
        fileName = StringUtils.isBlank((String)fileName) ? info.path : fileName;
        IPathState.NodeKind nodeKind = SVNConnectorSubversionClient.toNodeKind2(info.kind);
        String schedule = "";
        if (info.schedule == SVNEntryInfo.ScheduledOperation.ADD) {
            schedule = "add";
        } else if (info.schedule == SVNEntryInfo.ScheduledOperation.DELETE) {
            schedule = "delete";
        } else if (info.schedule == SVNEntryInfo.ScheduledOperation.NORMAL) {
            schedule = "normal";
        } else if (info.schedule == SVNEntryInfo.ScheduledOperation.REPLACE) {
            schedule = "replace";
        }
        return new Info(file, fileName, info.url, info.reposRootUrl, info.reposUUID, nodeKind, schedule, info.copyFromUrl, info.copyFromUrl == null ? 0L : info.copyFromRevision, info.revision, info.lastChangedRevision > 0L ? info.lastChangedRevision : 0L, null);
    }

    public byte[] cat(final String url, final String pegRevision, final String opRevision, final IProgressMonitor monitor) throws ScmCommunicationException {
        return this.run(new ISVNConnectorOperation<byte[]>(){

            @Override
            public byte[] run(ISVNConnector connector) throws SVNConnectorException {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
                connector.streamFileContent(new SVNEntryRevisionReference(url, SVNRevision.fromString((String)pegRevision), SVNRevision.fromString((String)opRevision)), 2048L, (OutputStream)new OutputStreamWithProgress((OutputStream)stream, monitor), (ISVNProgressMonitor)new SVNNullProgressMonitor());
                return stream.toByteArray();
            }
        }, null);
    }

    public LogEntry[] log(final String url, final String pegRevision, final String earliestRevision, final String latestRevision, final boolean includeFileList, final int limit, String type, final IProgressMonitor monitor) throws ScmCommunicationException {
        return this.run(new ISVNConnectorOperation<LogEntry[]>(){

            @Override
            public LogEntry[] run(ISVNConnector connector) throws SVNConnectorException {
                monitor.beginTask("Loading log", -1);
                long options = 0L;
                if (includeFileList) {
                    options |= 0x40000L;
                }
                final ArrayList logEntries = new ArrayList();
                SVNConnectorSubversionClient.logEntries(connector, new SVNEntryReference(url, SVNRevision.fromString((String)pegRevision)), new SVNRevisionRange[]{new SVNRevisionRange(SVNRevision.fromString((String)latestRevision), SVNRevision.fromString((String)earliestRevision))}, limit, options, new ISVNLogEntryCallback(){

                    public void next(SVNLogEntry log) {
                        logEntries.add(SVNConnectorSubversionClient.this.toLogEntry(log));
                        monitor.worked(1);
                    }
                }, (ISVNProgressMonitor)new SVNNullProgressMonitor());
                monitor.done();
                return logEntries.toArray(LogEntry.EMPTY_ARRAY);
            }
        }, null);
    }

    private char convertChangeTypeToChar(SVNLogPath.ChangeType type) {
        if (type == SVNLogPath.ChangeType.ADDED) {
            return 'A';
        }
        if (type == SVNLogPath.ChangeType.DELETED) {
            return 'D';
        }
        if (type == SVNLogPath.ChangeType.REPLACED) {
            return 'R';
        }
        if (type == SVNLogPath.ChangeType.MODIFIED) {
            return 'M';
        }
        throw new RuntimeException("Unrecognized ChangeType: ");
    }

    private LogEntry toLogEntry(SVNLogEntry logEntry) {
        int numChangedPaths = logEntry.changedPaths == null ? 0 : logEntry.changedPaths.length;
        LogPath[] paths = new LogPath[numChangedPaths];
        for (int i = 0; i < paths.length; ++i) {
            SVNLogPath changedPath = logEntry.changedPaths[i];
            paths[i] = new LogPath(changedPath.path, logEntry.revision, this.convertChangeTypeToChar(changedPath.action), changedPath.copiedFromPath, changedPath.copiedFromPath == null ? 0L : changedPath.copiedFromRevision, null);
        }
        return new LogEntry(logEntry.revision, logEntry.author, UtcDateUtils.UTC((long)logEntry.date), StringUtils.defaultString((String)logEntry.message), paths);
    }

    public List<StatusEntry> status(final File file, final boolean recursive, final boolean getAll, final boolean ignoreExternals, final IProgressMonitor monitor) throws ScmCommunicationException, SubversionNotWorkingCopyException {
        return this.run(new ISVNConnectorOperation<List<StatusEntry>>(){

            @Override
            public List<StatusEntry> run(ISVNConnector connector) throws SVNConnectorException {
                monitor.beginTask("Loading status", -1);
                long options = 0L;
                if (getAll) {
                    options |= 0x80L;
                }
                if (ignoreExternals) {
                    options |= 1L;
                }
                final ArrayList<StatusEntry> statusEntries = new ArrayList<StatusEntry>();
                SVNDepth depth = recursive ? SVNDepth.INFINITY : SVNDepth.EMPTY;
                connector.status(file.getPath(), depth, options, null, new ISVNEntryStatusCallback(){

                    public void next(SVNChangeStatus status) {
                        statusEntries.add(SVNConnectorSubversionClient.this.toStatusEntry(status));
                        monitor.worked(1);
                    }
                }, (ISVNProgressMonitor)new SVNNullProgressMonitor());
                monitor.done();
                return statusEntries;
            }
        }, file);
    }

    private StatusEntry toStatusEntry(SVNChangeStatus status) {
        String revision = null;
        if (status.revision > 0L) {
            revision = String.valueOf(status.revision);
        }
        return new StatusEntry(this.toStatusCode(status.textStatus), status.isCopied ? (char)'+' : ' ', status.isSwitched ? (char)'S' : ' ', new File(status.path), revision);
    }

    private StatusEntry.StatusCode toStatusCode(SVNEntryStatus.Kind kind) {
        if (kind == SVNEntryStatus.Kind.ADDED) {
            return StatusEntry.StatusCode.ADDED;
        }
        if (kind == SVNEntryStatus.Kind.CONFLICTED) {
            return StatusEntry.StatusCode.CONFLICTED;
        }
        if (kind == SVNEntryStatus.Kind.DELETED) {
            return StatusEntry.StatusCode.DELETED;
        }
        if (kind == SVNEntryStatus.Kind.EXTERNAL) {
            return StatusEntry.StatusCode.EXTERNAL;
        }
        if (kind == SVNEntryStatus.Kind.IGNORED) {
            return StatusEntry.StatusCode.IGNORED;
        }
        if (kind == SVNEntryStatus.Kind.INCOMPLETE) {
            return StatusEntry.StatusCode.INCOMPLETE;
        }
        if (kind == SVNEntryStatus.Kind.MERGED) {
            return StatusEntry.StatusCode.MERGED;
        }
        if (kind == SVNEntryStatus.Kind.MISSING) {
            return StatusEntry.StatusCode.MISSING;
        }
        if (kind == SVNEntryStatus.Kind.MODIFIED) {
            return StatusEntry.StatusCode.MODIFIED;
        }
        if (kind == SVNEntryStatus.Kind.NONE) {
            return StatusEntry.StatusCode.NONE;
        }
        if (kind == SVNEntryStatus.Kind.NORMAL) {
            return StatusEntry.StatusCode.NORMAL;
        }
        if (kind == SVNEntryStatus.Kind.OBSTRUCTED) {
            return StatusEntry.StatusCode.OBSTRUCTED;
        }
        if (kind == SVNEntryStatus.Kind.REPLACED) {
            return StatusEntry.StatusCode.REPLACED;
        }
        if (kind == SVNEntryStatus.Kind.UNVERSIONED) {
            return StatusEntry.StatusCode.UNVERSIONED;
        }
        throw new RuntimeException("Unrecognized status kind: " + kind);
    }

    public void commit(final Iterable<File> files, final boolean recursive, String comment, IProgressMonitor monitor) throws ScmCommunicationException {
        final String message = Joiner.on((char)'\n').join((Object[])Strings.breakIntoLines((String)comment));
        this.run(new ISVNConnectorOperation<Void>(){

            @Override
            public Void run(ISVNConnector connector) throws SVNConnectorException {
                ArrayList paths = Lists.newArrayList((Iterable)Iterables.transform((Iterable)files, (Function)new Function<File, String>(){

                    public String apply(File file) {
                        return file.getPath();
                    }
                }));
                connector.commit(paths.toArray(ArrayUtils.EMPTY_STRING_ARRAY), message, null, recursive ? SVNDepth.INFINITY : SVNDepth.EMPTY, 0L, null, (ISVNProgressMonitor)new SVNNullProgressMonitor());
                return null;
            }
        }, null);
    }

    public void add(final File file, final boolean recurse, IProgressMonitor monitor) throws ScmCommunicationException, SubversionNotWorkingCopyException {
        this.run(new ISVNConnectorOperation<Void>(){

            @Override
            public Void run(ISVNConnector connector) throws SVNConnectorException {
                connector.add(file.getPath(), recurse ? SVNDepth.INFINITY : SVNDepth.EMPTY, 0L, (ISVNProgressMonitor)new SVNNullProgressMonitor());
                return null;
            }
        }, file);
    }

    public void add(Collection<File> files, boolean recurse, IProgressMonitor monitor) throws ScmCommunicationException, SubversionNotWorkingCopyException {
        IteratorWithProgress itr = IteratorWithProgress.getIterator(files, (String)"Adding files", (IProgressMonitor)monitor);
        while (itr.hasNext()) {
            this.add((File)itr.next(), recurse, itr.getIterationProgressMonitor());
        }
    }

    private ScmCommunicationException toScmException(File file, SVNConnectorException e) {
        switch (e.getErrorId()) {
            case 155007: {
                return new SubversionNotWorkingCopyException(file, e.getMessage(), (Throwable)e);
            }
            case 155010: 
            case 200005: {
                return new SubversionNotVersionedResourceException(file, e.getMessage(), (Throwable)e);
            }
            case 160006: {
                return new SubversionNoSuchRevisionException((int)NumberUtils.parseLong((String)e.getMessage(), (long)-1L));
            }
            case 170001: 
            case 175013: {
                return new SubversionAccessForbiddenException(e.getMessage());
            }
        }
        return new ScmCommunicationException((Exception)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R run(ISVNConnectorOperation<R> operation, File localFile) throws ScmCommunicationException {
        ISVNConnector connector = null;
        try {
            connector = this.location.acquireSVNProxy();
            R r = operation.run(connector);
            return r;
        }
        catch (SVNConnectorException e) {
            throw this.toScmException(localFile, e);
        }
        catch (Exception e) {
            CollaboratorUI.openError((Shell)CollaboratorUI.getShell(), (String)("Error occurr  " + e.getMessage()), (Throwable)e, (boolean)true, (boolean)true);
            R r = null;
            return r;
        }
        finally {
            if (connector != null) {
                this.location.releaseSVNProxy(connector);
            }
        }
    }

    public List<ListEntry> list(final String directoryUrl, final String revision, IProgressMonitor monitor) throws ScmCommunicationException {
        return this.run(new ISVNConnectorOperation<List<ListEntry>>(){

            @Override
            public List<ListEntry> run(ISVNConnector connector) throws SVNConnectorException {
                final ArrayList<ListEntry> results = new ArrayList<ListEntry>();
                SVNConnectorSubversionClient.list(connector, new SVNEntryRevisionReference(directoryUrl, SVNRevision.fromString((String)revision), SVNRevision.fromString((String)revision)), SVNDepth.INFINITY, 1, new ISVNEntryCallback(){

                    public void next(SVNEntry entry) {
                        results.add(new ListEntry(entry.path, SVNConnectorSubversionClient.toNodeKind2(entry.nodeKind)));
                    }
                }, (ISVNProgressMonitor)new SVNNullProgressMonitor());
                return results;
            }
        }, null);
    }

    private static interface ISVNConnectorOperation<R> {
        public R run(ISVNConnector var1) throws SVNConnectorException;
    }
}

