/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.internal.links.query.BaseAuditableLinkQueryModel;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.dto.AncestorReport;
import com.ibm.team.scm.common.internal.dto.NameItemPair;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.ScmOptions;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.rtc.IRtcClientConfiguration;
import com.smartbear.collaborator.rtc.RtcAtomicChangesSelectionPage;
import com.smartbear.collaborator.rtc.RtcClientConfiguration;
import com.smartbear.collaborator.rtc.RtcPatch;
import com.smartbear.collaborator.rtc.RtcPluginApiConfigFactory;
import com.smartbear.collaborator.rtc.RtcReviewFinishedHandler;
import com.smartbear.collaborator.rtc.RtcVersionFactory;
import com.smartbear.collaborator.ui.ide.actions.AddToReviewAction;
import com.smartbear.collaborator.ui.wizards.AddToReviewWizard;
import com.smartbear.collaborator.ui.wizards.IChangesSelectionPage;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.util.SmartBearUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class AddChangeSetToReviewAction
extends AddToReviewAction {
    public static final String ADD_WORKITEM_WITH_CHILDREN_TO_REVIEW = "com.smartbear.collaborator.rtc.AddWorkItemWithChildrenToReview";
    public static String LINK_TYPE_CHANGE_SET = "com.ibm.team.filesystem.workitems.change_set";
    public static String LINK_TYPE_WORK_ITEM = "com.ibm.team.workitem.linktype.parentworkitem";
    static final Log LOG = LogFactory.getLog(AddChangeSetToReviewAction.class);

    protected AddToReviewWizard getWizard(ISelection selection) throws CoreException {
        Collection<RepositoryChanges> allChanges = this.extractChanges(((IStructuredSelection)selection).toList());
        ArrayList<RtcPatch> patches = new ArrayList<RtcPatch>();
        for (RepositoryChanges repoChanges : allChanges) {
            ITeamRepository repo = repoChanges.getRepository();
            try {
                for (ChangeSetSummary changeSetSummary : repoChanges.getChangeSetSummary().values()) {
                    IChangeSet changeSet = changeSetSummary.getChangeSet();
                    IContributor modifiedBy = changeSetSummary.getModifiedBy();
                    IComponent component = this.findComponent(repo, changeSet.getComponent());
                    IWorkspaceManager workspaceMgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                    IWorkspaceHandle workspace = this.searchWorkspaceHandle(workspaceMgr, changeSet);
                    RtcClientConfiguration config = new RtcClientConfiguration(repo, component, workspace);
                    RtcPatch patch = new RtcPatch(config, changeSet, modifiedBy);
                    for (ChangeSummary changeSummary : changeSetSummary.getChanges()) {
                        IVersionableHandle vh = changeSummary.getChange().afterState();
                        if (vh == null) {
                            vh = changeSummary.getChange().beforeState();
                        }
                        try {
                            IVersionable v = config.fetchVersionable(vh, (IProgressMonitor)new NullProgressMonitor());
                            if (!(v instanceof IFileItem)) continue;
                            patch.add(RtcVersionFactory.loadVersions((IRtcClientConfiguration)config, (IScmChangelist)patch, (IChange)changeSummary.getChange(), (String)changeSummary.getAfterPath(), (String)changeSummary.getBeforePath()));
                        }
                        catch (ScmCommunicationException e) {
                            throw new CoreException((IStatus)new Status(4, "com.smartbear.collaborator.rtc", e.getMessage(), (Throwable)e));
                        }
                    }
                    patches.add(patch);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error finding Workspace for selected change set", (Throwable)e);
            }
        }
        ScmOptions scmOptions = new ScmOptions();
        scmOptions.setScm("rtc");
        scmOptions.setRtcImpl(RtcPluginApiConfigFactory.INSTANCE.name());
        RtcPatch first = (RtcPatch)SmartBearUtils.getFirstObject(patches);
        if (first != null) {
            String repoURI = first.getClientConfiguration().teamRepo.getRepositoryURI();
            scmOptions.setRtcRepositoryURI(repoURI);
        }
        RtcAtomicChangesSelectionPage changesPage = new RtcAtomicChangesSelectionPage("Change Sets", (IScmOptions)scmOptions, patches);
        changesPage.setDefaultSelection((IStructuredSelection)new StructuredSelection(patches));
        return new AddToReviewWizard("Add Change Sets", (IChangesSelectionPage)changesPage);
    }

    private Collection<RepositoryChanges> extractChanges(List<?> list) {
        HashMap<ITeamRepository, RepositoryChanges> repoCache = new HashMap<ITeamRepository, RepositoryChanges>();
        for (Object o : list) {
            IRemoteActivity activity;
            Object obj2;
            ChangeDescriptor change = null;
            ArrayList<ChangeSummary> changes = new ArrayList<ChangeSummary>();
            if (o instanceof IRemoteActivity) {
                IRemoteActivity activity2 = (IRemoteActivity)o;
                if (activity2.getChanges().isEmpty()) {
                    changes = this.fetchChangeSummaries(activity2);
                } else {
                    for (Object obj2 : activity2.getChanges()) {
                        IRemoteChangeSummary remoteChangeSummary = (IRemoteChangeSummary)obj2;
                        ChangeSummary changeSummary = new ChangeSummary(remoteChangeSummary);
                        changes.add(changeSummary);
                    }
                }
                change = new ChangeDescriptor(this.getTeamRepository(activity2.getActivitySource()), activity2.getChangeSet(), activity2.getModifiedBy(), changes);
                this.extractChanges(change, repoCache);
                continue;
            }
            if (o instanceof IRemoteChangeSummary) {
                IRemoteChangeSummary remoteChange = (IRemoteChangeSummary)o;
                activity = remoteChange.getActivity();
                changes.add(new ChangeSummary(remoteChange));
                change = new ChangeDescriptor(this.getTeamRepository(activity.getActivitySource()), activity.getChangeSet(), activity.getModifiedBy(), changes);
                this.extractChanges(change, repoCache);
                continue;
            }
            if (o instanceof IActivityFolder) {
                IActivityFolder activityFolder = (IActivityFolder)o;
                activity = activityFolder.getActivity();
                obj2 = activity.getChanges(activityFolder).iterator();
                while (obj2.hasNext()) {
                    Object obj3 = obj2.next();
                    IRemoteChangeSummary remoteChangeSummary = (IRemoteChangeSummary)obj3;
                    changes.add(new ChangeSummary(remoteChangeSummary));
                }
                change = new ChangeDescriptor(this.getTeamRepository(activity.getActivitySource()), activity.getChangeSet(), activity.getModifiedBy(), changes);
                this.extractChanges(change, repoCache);
                continue;
            }
            if (o instanceof ChangeSetWrapper) {
                change = this.processChangeSetWrapper((ChangeSetWrapper)o);
                this.extractChanges(change, repoCache);
                continue;
            }
            if (o instanceof IHistoryEntry) {
                change = this.processChangeSetWrapper(((IHistoryEntry)o).getChangeSet());
                this.extractChanges(change, repoCache);
                continue;
            }
            if (o instanceof IWorkItem) {
                boolean withChildren = ADD_WORKITEM_WITH_CHILDREN_TO_REVIEW.equals(this.actionId);
                List<ChangeSetWrapper> changeSetList = this.findWorkItemChangeSets((IWorkItem)o, withChildren);
                obj2 = changeSetList.iterator();
                while (obj2.hasNext()) {
                    ChangeSetWrapper changeSet = (ChangeSetWrapper)obj2.next();
                    change = this.processChangeSetWrapper(changeSet);
                    this.extractChanges(change, repoCache);
                }
                this.setAddToReviewListener((IJobChangeListener)new RtcReviewFinishedHandler((IWorkItem)o));
                continue;
            }
            if (o instanceof IReference) {
                ITeamRepository repo;
                ILink link;
                IReference reference = (IReference)o;
                if (reference == null || (link = reference.getLink()) == null) continue;
                if (LINK_TYPE_CHANGE_SET.equals(link.getLinkTypeId())) {
                    IChangeSetHandle changeSetHandle = (IChangeSetHandle)link.getSourceRef().resolve();
                    repo = (ITeamRepository)changeSetHandle.getOrigin();
                    try {
                        IChangeSet changeSet = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)changeSetHandle, 0, null);
                        change = this.processChangeSetWrapper(new ChangeSetWrapper(repo, changeSet));
                        this.extractChanges(change, repoCache);
                    }
                    catch (TeamRepositoryException e) {
                        LOG.error((Object)"Error fetching changes", (Throwable)e);
                    }
                    continue;
                }
                if (!LINK_TYPE_WORK_ITEM.equals(link.getLinkTypeId())) continue;
                IWorkItemHandle workItemHandle = (IWorkItemHandle)link.getSourceRef().resolve();
                repo = (ITeamRepository)workItemHandle.getOrigin();
                try {
                    IWorkItem workItem = (IWorkItem)repo.itemManager().fetchCompleteItem((IItemHandle)workItemHandle, 0, null);
                    List<ChangeSetWrapper> changeSetList = this.findWorkItemChangeSets(workItem, false);
                    for (ChangeSetWrapper changeSet : changeSetList) {
                        change = this.processChangeSetWrapper(changeSet);
                        this.extractChanges(change, repoCache);
                    }
                    continue;
                }
                catch (TeamRepositoryException e) {
                    LOG.error((Object)"Error fetching changes", (Throwable)e);
                    continue;
                }
            }
            LOG.debug((Object)("Unhandled type while extracting changes" + o));
        }
        return repoCache.values();
    }

    private ITeamRepository getTeamRepository(IActivitySource activitySource) {
        ITeamRepository teamRepo = null;
        Method remoteRepositoryMethod = null;
        IComponentSyncContext component = activitySource.getModel();
        try {
            remoteRepositoryMethod = IComponentSyncContext.class.getMethod("remoteTeamRepository", null);
            teamRepo = (ITeamRepository)remoteRepositoryMethod.invoke((Object)component, (Object[])null);
        }
        catch (Exception e) {
            LOG.info((Object)"Method remoteTeamRepository() i snot exists in IComponentSyncContext class.", (Throwable)e);
        }
        if (teamRepo == null) {
            try {
                remoteRepositoryMethod = IComponentSyncContext.class.getMethod("getRemoteOutgoingTeamRepository", null);
                teamRepo = (ITeamRepository)remoteRepositoryMethod.invoke((Object)component, (Object[])null);
            }
            catch (Exception e) {
                LOG.info((Object)"Method getRemoteOutgoingTeamRepository() i snot exists in IComponentSyncContext class.", (Throwable)e);
            }
        }
        if (teamRepo == null) {
            teamRepo = activitySource.getTeamRepository();
        }
        return teamRepo;
    }

    public void loadWorkItemChangeSets(ITeamRepository repo, IWorkItem workItem, List<IChangeSet> changeSets, boolean withChildren) {
        BaseAuditableLinkQueryModel.AuditableLinkQueryModel linkQueryModel = BaseAuditableLinkQueryModel.AuditableLinkQueryModel.ROOT;
        IItemManager itemManager = repo.itemManager();
        IClientLibraryContext clientContext = (IClientLibraryContext)repo;
        IQueryService queryService = (IQueryService)clientContext.getServiceInterface(IQueryService.class);
        IItemQuery changeSetQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)linkQueryModel);
        changeSetQuery.filter(linkQueryModel.name()._eq(LINK_TYPE_CHANGE_SET)._and(linkQueryModel.targetRef().referencedItem().itemId()._eq((IUUID)changeSetQuery.newUUIDArg())));
        try {
            IItemQueryPage changeSetQueryPage = queryService.queryItems(changeSetQuery, new Object[]{workItem.getItemId()}, 512);
            ArrayList<IChangeSetHandle> changeSetHandles = new ArrayList<IChangeSetHandle>();
            for (ILink link : itemManager.fetchCompleteItems(changeSetQueryPage.getItemHandles(), 0, null)) {
                IChangeSetHandle changeSetHandle = (IChangeSetHandle)link.getSourceRef().resolve();
                changeSetHandles.add(changeSetHandle);
            }
            changeSets.addAll(itemManager.fetchCompleteItems(changeSetHandles, 0, null));
            if (withChildren) {
                IItemQuery workItemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)linkQueryModel);
                workItemQuery.filter(linkQueryModel.name()._eq(LINK_TYPE_WORK_ITEM)._and(linkQueryModel.targetRef().referencedItem().itemId()._eq((IUUID)workItemQuery.newUUIDArg())));
                IItemQueryPage workItemQueryPage = queryService.queryItems(workItemQuery, new Object[]{workItem.getItemId()}, 512);
                List workItemLinkList = itemManager.fetchCompleteItems(workItemQueryPage.getItemHandles(), 0, null);
                if (!workItemLinkList.isEmpty()) {
                    ArrayList<IWorkItemHandle> workItemHandles = new ArrayList<IWorkItemHandle>();
                    for (ILink link : workItemLinkList) {
                        IWorkItemHandle workItemHandle = (IWorkItemHandle)link.getSourceRef().resolve();
                        workItemHandles.add(workItemHandle);
                    }
                    List workItems = itemManager.fetchCompleteItems(workItemHandles, 0, null);
                    for (IWorkItem childWorkItem : workItems) {
                        this.loadWorkItemChangeSets(repo, childWorkItem, changeSets, withChildren);
                    }
                }
            }
        }
        catch (TeamRepositoryException e) {
            LOG.error((Object)"Error fetching changes", (Throwable)e);
        }
    }

    public List<ChangeSetWrapper> findWorkItemChangeSets(IWorkItem workItem, boolean withChildren) {
        ITeamRepositoryService repoService = TeamPlatform.getTeamRepositoryService();
        ITeamRepository[] repos = repoService.getTeamRepositories();
        ArrayList<ChangeSetWrapper> items = new ArrayList<ChangeSetWrapper>();
        BaseAuditableLinkQueryModel.AuditableLinkQueryModel linkQueryModel = BaseAuditableLinkQueryModel.AuditableLinkQueryModel.ROOT;
        for (ITeamRepository repo : repos) {
            ArrayList<IChangeSet> changeSets = new ArrayList<IChangeSet>();
            this.loadWorkItemChangeSets(repo, workItem, changeSets, withChildren);
            for (IChangeSet changeSet : changeSets) {
                items.add(new ChangeSetWrapper(repo, changeSet));
            }
        }
        return items;
    }

    private ChangeDescriptor processChangeSetWrapper(ChangeSetWrapper wrapper) {
        ITeamRepository remote = wrapper.getRepository();
        IChangeSet changeSet = wrapper.getChangeSet();
        IContributor modifiedBy = null;
        RtcClientConfiguration config = new RtcClientConfiguration(remote, this.findComponent(remote, changeSet.getComponent()));
        try {
            modifiedBy = config.fetchContributor(changeSet.getModifiedBy(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ScmCommunicationException e) {
            LOG.error((Object)e);
            throw new RuntimeException(e);
        }
        List<ChangeSummary> changes = this.fetchChangeSummaries(remote, changeSet, null);
        return new ChangeDescriptor(remote, changeSet, modifiedBy, changes);
    }

    private void extractChanges(ChangeDescriptor change, Map<ITeamRepository, RepositoryChanges> repoCache) {
        ChangeSetSummary changeSetSummary;
        ITeamRepository remote = change.repository;
        IChangeSet changeSet = change.changeSet;
        IContributor modifiedBy = change.modifiedBy;
        List<ChangeSummary> changes = change.changes;
        RepositoryChanges repo = repoCache.get(remote);
        if (repo == null) {
            repo = new RepositoryChanges(remote);
            repoCache.put(remote, repo);
        }
        if ((changeSetSummary = repo.getChangeSetSummary().get(changeSet)) == null) {
            changeSetSummary = new ChangeSetSummary(changeSet);
            changeSetSummary.modifiedBy = modifiedBy;
            repo.getChangeSetSummary().put(changeSet, changeSetSummary);
        }
        changeSetSummary.getChanges().addAll(changes);
        this.setAddToReviewListener((IJobChangeListener)new RtcReviewFinishedHandler(this.findWorkItemByChange(change)));
    }

    private IComponent findComponent(ITeamRepository repository, IComponentHandle handle) {
        IComponent component = null;
        try {
            component = (IComponent)repository.itemManager().fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (TeamRepositoryException e) {
            LOG.error((Object)"Could not retrieve component. Setting component to null", (Throwable)e);
        }
        return component;
    }

    private List<ChangeSummary> fetchChangeSummaries(IRemoteActivity activity) {
        ITeamRepository repository = this.getTeamRepository(activity.getActivitySource());
        IChangeSet changeSet = activity.getChangeSet();
        IWorkspace workspace = activity.getActivitySource().getWorkspace();
        return this.fetchChangeSummaries(repository, changeSet, (IWorkspaceHandle)workspace);
    }

    private List<ChangeSummary> fetchChangeSummaries(ITeamRepository repository, IChangeSet changeSet, IWorkspaceHandle workspace) {
        IComponent component = this.findComponent(repository, changeSet.getComponent());
        RtcClientConfiguration config = new RtcClientConfiguration(repository, component);
        ArrayList<ChangeSummary> changes = new ArrayList<ChangeSummary>();
        try {
            IWorkspaceManager workspaceMgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
            if (workspace == null) {
                try {
                    workspace = this.searchWorkspaceHandle(workspaceMgr, changeSet);
                }
                catch (Exception e) {
                    return changes;
                }
            }
            IWorkspaceConnection connection = workspaceMgr.getWorkspaceConnection(workspace, (IProgressMonitor)new NullProgressMonitor());
            IConfiguration workspaceConfig = this.findConfiguration(changeSet, connection, (IComponentHandle)component);
            for (Object chgObj : changeSet.changes()) {
                IChange change = (IChange)chgObj;
                if (change.afterState() == null && change.beforeState() == null) continue;
                IVersionable file = config.fetchVersionable(change.afterState(), (IProgressMonitor)new NullProgressMonitor());
                IVersionable previous = config.fetchVersionable(change.beforeState(), (IProgressMonitor)new NullProgressMonitor());
                ChangeSummary summary = new ChangeSummary();
                summary.afterPath = this.findPath(file, workspaceConfig);
                summary.beforePath = this.findPath(previous, workspaceConfig);
                summary.change = change;
                changes.add(summary);
            }
        }
        catch (TeamRepositoryException | ScmCommunicationException e) {
            LOG.error((Object)"Error fetching changes", e);
        }
        return changes;
    }

    private IConfiguration findConfiguration(IChangeSet changeSet, IWorkspaceConnection connection, IComponentHandle component) throws TeamRepositoryException {
        for (IChangeHistory history = connection.changeHistory(component); history != null; history = history.previousHistory((IProgressMonitor)new NullProgressMonitor())) {
            List changesets = history.recent((IProgressMonitor)new NullProgressMonitor());
            for (Object chgObj : changesets) {
                IChangeHistoryEntryChange recentChange;
                if (!(chgObj instanceof IChangeHistoryEntryChange) || !(recentChange = (IChangeHistoryEntryChange)chgObj).changeSet().sameItemId((IItemHandle)changeSet)) continue;
                return history.configuration();
            }
        }
        return null;
    }

    private String findPath(IVersionable file, IConfiguration configuration) throws TeamRepositoryException {
        if (file == null || configuration == null) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        List ancestorReport = configuration.determineAncestorsInHistory(Collections.singletonList(file), null);
        if (!ancestorReport.isEmpty()) {
            List nameItemPairs = ((AncestorReport)ancestorReport.get(0)).getPairs();
            for (NameItemPair step : nameItemPairs) {
                String itemName = step.getName();
                if (itemName == null) continue;
                path.append("/" + step.getName());
            }
        } else {
            throw new TeamRepositoryException("Can't find file path");
        }
        return path.toString();
    }

    private IWorkspaceHandle searchWorkspaceHandle(IWorkspaceManager workspaceMgr, IChangeSet changeSet) throws TeamRepositoryException {
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(2);
        List workspaces = workspaceMgr.findWorkspacesContainingChangeset((IChangeSetHandle)changeSet, criteria, 100, (IProgressMonitor)new NullProgressMonitor());
        if (workspaces == null || workspaces.isEmpty()) {
            throw new TeamRepositoryException("Can't find workspace");
        }
        return (IWorkspaceHandle)workspaces.get(0);
    }

    private IWorkItem findWorkItemByChange(ChangeDescriptor changeDescriptor) {
        try {
            List links = ChangeSetLinks.findLinks((ProviderFactory)((ProviderFactory)changeDescriptor.repository.getClientLibrary(ProviderFactory.class)), (IChangeSetHandle)changeDescriptor.changeSet, (IProgressMonitor)new NullProgressMonitor());
            for (ILink link : links) {
                IReference targetRef = link.getTargetRef();
                if (!targetRef.isItemReference() || !(((IItemReference)targetRef).getReferencedItem() instanceof IWorkItemHandle)) continue;
                IWorkItemHandle workItemHandle = (IWorkItemHandle)((IItemReference)targetRef).getReferencedItem();
                IWorkItem workItem = (IWorkItem)changeDescriptor.repository.itemManager().fetchCompleteItem((IItemHandle)workItemHandle, 0, null);
                return workItem;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return null;
    }

    private static class ChangeSummary {
        private String afterPath;
        private String beforePath;
        private IChange change;

        public ChangeSummary() {
        }

        public ChangeSummary(IRemoteChangeSummary remoteChangeSummary) {
            this.afterPath = remoteChangeSummary.getAfterPath();
            this.beforePath = remoteChangeSummary.getBeforePath();
            this.change = remoteChangeSummary.getChange();
        }

        public String getAfterPath() {
            return this.afterPath;
        }

        public String getBeforePath() {
            return this.beforePath;
        }

        public IChange getChange() {
            return this.change;
        }
    }

    private static class ChangeSetSummary {
        private IChangeSet changeSet;
        private IContributor modifiedBy;
        private List<ChangeSummary> changes = new ArrayList<ChangeSummary>();

        public ChangeSetSummary(IChangeSet changeSet) {
            this.changeSet = changeSet;
        }

        public List<ChangeSummary> getChanges() {
            return this.changes;
        }

        public IChangeSet getChangeSet() {
            return this.changeSet;
        }

        public IContributor getModifiedBy() {
            return this.modifiedBy;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ChangeSetSummary)) {
                return false;
            }
            ChangeSetSummary other = (ChangeSetSummary)obj;
            return this.changeSet.equals(other.changeSet);
        }
    }

    private static class RepositoryChanges {
        private ITeamRepository repository;
        private Map<IChangeSet, ChangeSetSummary> changeSetSummary = new LinkedHashMap<IChangeSet, ChangeSetSummary>();

        public RepositoryChanges(ITeamRepository repository) {
            this.repository = repository;
        }

        public Map<IChangeSet, ChangeSetSummary> getChangeSetSummary() {
            return this.changeSetSummary;
        }

        public ITeamRepository getRepository() {
            return this.repository;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RepositoryChanges)) {
                return false;
            }
            RepositoryChanges other = (RepositoryChanges)obj;
            return this.repository.equals(other);
        }

        public int hashCode() {
            return this.repository.hashCode();
        }
    }

    private static class ChangeDescriptor {
        private final ITeamRepository repository;
        private final IChangeSet changeSet;
        private final IContributor modifiedBy;
        private final List<ChangeSummary> changes;

        public ChangeDescriptor(ITeamRepository repository, IChangeSet changeSet, IContributor modifiedBy, List<ChangeSummary> changes) {
            this.repository = repository;
            this.changeSet = changeSet;
            this.modifiedBy = modifiedBy;
            this.changes = changes;
        }
    }
}

