/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc;

import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.smartbear.collaborator.ui.ide.CollaboratorIDEUI;
import com.smartbear.util.SmartBearUtils;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ReviewLinkHandler
extends HyperlinkHandler {
    private static final String PLUGIN_ID = "com.smartbear.collaborator.rtc";
    private final Pattern reviewUriPattern = Pattern.compile("page=ReviewDisplay&reviewid=(\\d+)");

    public boolean handles(URI uri) {
        return this.reviewUriPattern.matcher(uri.getQuery()).matches();
    }

    public IStatus open2(URI uri, ContextProvider provider, IProgressMonitor monitor) {
        Matcher matcher = this.reviewUriPattern.matcher(uri.getQuery());
        if (!matcher.matches()) {
            return new Status(4, PLUGIN_ID, "Could not determine review ID");
        }
        int reviewId = Integer.valueOf(matcher.group(1));
        IWorkbenchWindow window = this.bestEffortGrabAWindow(provider);
        if (window == null) {
            return super.open2(uri, provider, monitor);
        }
        Throwable t = CollaboratorIDEUI.openReview((IWorkbenchWindow)window, (int)reviewId);
        if (t != null) {
            return new Status(4, PLUGIN_ID, t.getMessage(), t);
        }
        return Status.OK_STATUS;
    }

    private IWorkbenchWindow bestEffortGrabAWindow(ContextProvider provider) {
        Object uiContext = provider.findUIContext();
        if (uiContext instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)uiContext;
        }
        if (uiContext instanceof IWorkbenchPage) {
            return ((IWorkbenchPage)uiContext).getWorkbenchWindow();
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            window = (IWorkbenchWindow)SmartBearUtils.getFirstObject((Object[])PlatformUI.getWorkbench().getWorkbenchWindows());
        }
        return window;
    }
}

