/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc;

import com.smartbear.beans.IScmOptions;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.rtc.RtcPatch;
import com.smartbear.collaborator.rtc.RtcVersion;
import com.smartbear.collaborator.scm.IScmChangeAdapter;
import com.smartbear.collaborator.scm.ScmChangeAdapter;
import com.smartbear.collaborator.ui.wizards.AtomicChangesSelectionPage;
import com.smartbear.collaborator.ui.wizards.AtomicChangesTreeViewer;
import com.smartbear.scm.IScmChangelist;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class RtcAtomicChangesSelectionPage
extends AtomicChangesSelectionPage {
    private final List<RtcPatch> patches;

    public RtcAtomicChangesSelectionPage(String atomicChangesLabel, IScmOptions options, List<RtcPatch> patches) {
        super(atomicChangesLabel, options);
        this.patches = patches;
    }

    protected StructuredViewer createViewer(Composite parent) {
        AtomicChangesTreeViewer viewer = new AtomicChangesTreeViewer(parent, 2048);
        viewer.setInput(this.patches);
        for (TreeItem treeItem : viewer.getTree().getItems()) {
            treeItem.setChecked(true);
        }
        return viewer;
    }

    public IScmChangeAdapter getSelectedChangesAdapter() throws ScmCommunicationException {
        TreeViewer treeViewer = (TreeViewer)this.viewer;
        Tree tree = treeViewer.getTree();
        ArrayList<RtcPatch> changes = new ArrayList<RtcPatch>();
        for (TreeItem item : tree.getItems()) {
            if (!(item.getData() instanceof RtcPatch) || !item.getChecked()) continue;
            RtcPatch patch = (RtcPatch)item.getData();
            TreeItem[] changeItems = item.getItems();
            if (changeItems.length > 0) {
                block1: for (TreeItem changeItem : changeItems) {
                    RtcVersion version = (RtcVersion)changeItem.getData();
                    TreeItem[] histItems = changeItem.getItems();
                    for (int i = 0; i < histItems.length; ++i) {
                        TreeItem histItem = histItems[i];
                        if (!histItem.getChecked()) continue;
                        if (i == 0) continue block1;
                        RtcVersion histVersion = (RtcVersion)histItem.getData();
                        version.setPred(histVersion);
                        continue block1;
                    }
                }
            }
            changes.add(patch);
        }
        return new ScmChangeAdapter(changes.toArray(new IScmChangelist[changes.size()]), this.atomicChangesLabel, this.options, this.isPostCommit());
    }
}

