/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.content.IVersionedContentManager;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IVersionedContent;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.rtc.IRtcClientConfiguration;
import com.smartbear.collections.Tuple;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.IScmConnectionParameters;
import com.smartbear.scm.IScmLocalCheckout;
import com.smartbear.scm.IScmSystem;
import com.smartbear.scm.IScmVersion;
import com.smartbear.scm.ScmConfigurationException;
import com.smartbear.scm.impl.common.ScmConnectionParameters;
import com.smartbear.scm.impl.rtc.RtcSystem;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;

final class RtcClientConfiguration
implements IRtcClientConfiguration {
    final ITeamRepository teamRepo;
    final IComponent component;
    final IWorkspaceHandle workspace;

    static <T> T adapt(Object o, Class<T> clazz) {
        Object adapted;
        if (o instanceof IAdaptable && (adapted = ((IAdaptable)o).getAdapter(clazz)) != null) {
            return clazz.cast(adapted);
        }
        return clazz.cast(Platform.getAdapterManager().getAdapter(o, clazz));
    }

    RtcClientConfiguration(ITeamRepository teamRepo, IComponent component, IWorkspaceHandle workspace) {
        this.teamRepo = teamRepo;
        this.component = component;
        this.workspace = workspace;
    }

    RtcClientConfiguration(ITeamRepository teamRepo, IComponent component) {
        this(teamRepo, component, null);
    }

    public void logStatus(IProgressMonitor monitor) throws ScmCommunicationException {
    }

    public IScmVersion getVersion(Tuple<String> versionSpec, IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public String getUserName() {
        return this.teamRepo.getUserId();
    }

    public IScmConnectionParameters getServerConfiguration(IScmLocalCheckout checkout, IScmVersion version, IScmChangelist atomicChange) throws ScmConfigurationException, ScmCommunicationException {
        if (this.component != null) {
            return new ScmConnectionParameters(this.teamRepo.getRepositoryURI(), this.component.getName(), this.component.getItemId().getUuidValue());
        }
        return new ScmConnectionParameters(this.teamRepo.getRepositoryURI());
    }

    public IScmSystem getScmSystem() {
        return RtcSystem.INSTANCE;
    }

    public List<IScmLocalCheckout> getModifiedFiles(File directory, IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public IFileItem fetchFileItem(IVersionableHandle handle, IProgressMonitor monitor) throws ScmCommunicationException {
        try {
            return (IFileItem)SCMPlatform.getWorkspaceManager((ITeamRepository)this.teamRepo).versionableManager().fetchCompleteState(handle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (TeamRepositoryException e) {
            throw new ScmCommunicationException((Exception)((Object)e));
        }
    }

    public byte[] fetchContent(IVersionableHandle version, IProgressMonitor monitor) throws ScmCommunicationException {
        monitor.beginTask("Fetching Content", 4);
        IVersionable versionable = this.fetchVersionable(version, monitor);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            this.contentManager().retrieveContent((IVersionableHandle)versionable, (IVersionedContent)((IFileItem)versionable).getContent(), (OutputStream)bytes, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
        }
        catch (TeamRepositoryException e) {
            throw new ScmCommunicationException((Exception)((Object)e));
        }
        monitor.done();
        return bytes.toByteArray();
    }

    public IScmLocalCheckout getLocalCheckout(File path, IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public IScmChangelist[] getLocalChangelists(IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public String getDisplayableConfiguration() {
        String config = "Team Repository: " + this.teamRepo.getRepositoryURI();
        if (this.component != null) {
            config = config + " - Component: " + this.component.getName();
        }
        return config;
    }

    public IScmChangelist getChangelist(String id, IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public IContributor fetchContributor(IContributorHandle handle, IProgressMonitor monitor) throws ScmCommunicationException {
        try {
            return (IContributor)this.teamRepo.itemManager().fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (TeamRepositoryException e) {
            throw new ScmCommunicationException((Exception)((Object)e));
        }
    }

    private IVersionableManager versionableManager() {
        return SCMPlatform.getWorkspaceManager((ITeamRepository)this.teamRepo).versionableManager();
    }

    private IVersionedContentManager contentManager() {
        return SCMPlatform.getContentManager((ITeamRepository)this.teamRepo);
    }

    IVersionable fetchVersionable(IVersionableHandle handle, IProgressMonitor monitor) throws ScmCommunicationException {
        if (handle == null) {
            return null;
        }
        try {
            return this.versionableManager().fetchCompleteState(handle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (TeamRepositoryException e) {
            throw new ScmCommunicationException((Exception)((Object)e));
        }
    }

    public IChangeSet fetchChangeSet(IChangeSetHandle changeSetHandle) throws TeamRepositoryException {
        return (IChangeSet)this.teamRepo.itemManager().fetchCompleteItem((IItemHandle)changeSetHandle, 0, null);
    }

    public List getHistoryForVersionable(IVersionableHandle version, int limit) throws Exception {
        if (this.workspace == null) {
            throw new Exception("WorkspaceHandle is null for current RtcClientConfiguration");
        }
        IWorkspaceManager workspaceMgr = SCMPlatform.getWorkspaceManager((ITeamRepository)this.teamRepo);
        IWorkspaceConnection connection = workspaceMgr.getWorkspaceConnection(this.workspace, (IProgressMonitor)new NullProgressMonitor());
        IChangeHistory history = connection.changeHistory((IComponentHandle)this.component);
        return history.getHistoryFor(version, limit, true, (IProgressMonitor)new NullProgressMonitor());
    }
}

