/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc;

import com.ibm.team.repository.common.IContributor;
import com.ibm.team.scm.common.IChangeSet;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.rtc.RtcClientConfiguration;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.IScmCommitInfo;
import com.smartbear.scm.IScmLocalCheckout;
import com.smartbear.scm.IScmVersion;
import com.smartbear.scm.ScmAccessControlException;
import com.smartbear.scm.ScmCommitInfoSimple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

class RtcPatch
implements IScmChangelist {
    RtcClientConfiguration config;
    IChangeSet changeSet;
    IContributor modifiedBy;
    List<IScmVersion> patchParts = new ArrayList<IScmVersion>();

    public RtcPatch(RtcClientConfiguration config, IChangeSet changeSet, IContributor modifiedBy) {
        this.config = config;
        this.changeSet = changeSet;
        this.modifiedBy = modifiedBy;
    }

    public void add(List<IScmVersion> parts) {
        this.patchParts.addAll(parts);
    }

    public void checkAccessPermission(String user, IProgressMonitor monitor) throws ScmCommunicationException, ScmAccessControlException {
    }

    public RtcClientConfiguration getClientConfiguration() {
        return this.config;
    }

    public ScmCommitInfoSimple getCommitInfo() {
        ScmCommitInfoSimple info = new ScmCommitInfoSimple();
        info.setAuthor(this.modifiedBy.getName());
        info.setComment(this.changeSet.getComment());
        info.setDate(this.changeSet.getLastChangeDate());
        info.setState(IScmCommitInfo.State.CONTROLLED);
        return info;
    }

    public String getId() {
        return this.changeSet.getItemId().getUuidValue();
    }

    public List<IScmLocalCheckout> getLocalCheckouts(IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public List<IScmVersion> getVersions(IProgressMonitor monitor) throws ScmCommunicationException {
        return new ArrayList<IScmVersion>(this.patchParts);
    }

    public boolean isAtomic() {
        return true;
    }

    public boolean isPending() {
        return false;
    }

    public int compareTo(Object o) {
        return 0;
    }

    public List<String> getChangelistLog() {
        return Collections.EMPTY_LIST;
    }
}

