/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.smartbear.beans.IScmOptions;
import com.smartbear.collaborator.rtc.RtcClientConfiguration;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.ScmConfigurationException;
import com.smartbear.scm.impl.rtc.RtcSystem;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public final class RtcPluginApiConfigFactory
implements RtcSystem.IConfigFactory {
    public static final RtcSystem.IConfigFactory INSTANCE = new RtcPluginApiConfigFactory();

    private RtcPluginApiConfigFactory() {
    }

    public String name() {
        return "com.smartbear.collaborator.rtc.pluginAPIConfigFactory";
    }

    public IScmClientConfiguration getClientConfiguration(File checkout, IScmOptions options, IProgressMonitor monitor) throws ScmConfigurationException {
        return this.getClientConfiguration(options, monitor);
    }

    public IScmClientConfiguration getClientConfiguration(IScmOptions options, IProgressMonitor monitor) throws ScmConfigurationException {
        ITeamRepositoryService reposvc = TeamPlatform.getTeamRepositoryService();
        String repoURI = options.getRtcRepositoryURI();
        if (StringUtils.isBlank((String)repoURI)) {
            throw new ScmConfigurationException("RTC Respository URI must be provided");
        }
        ITeamRepository repo = reposvc.getTeamRepository(repoURI);
        if (repo.loggedIn()) {
            return new RtcClientConfiguration(repo, null);
        }
        for (ITeamRepository repo2 : reposvc.getTeamRepositories()) {
            if (!repo2.loggedIn() || !repo2.getRepositoryURI().equals(repoURI)) continue;
            return new RtcClientConfiguration(repo2, null);
        }
        throw new ScmConfigurationException("Could not determine which Team Repository to use");
    }

    static {
        RtcSystem.INSTANCE.register(INSTANCE);
    }
}

