/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc;

import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.Location;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.ScmOptions;
import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.admin.review.comment.CommandCommentCreate;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.jobs.AddToReviewJob;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewInfo;
import com.smartbear.collaborator.json.interfaces.user.response.UserInfo;
import com.smartbear.collaborator.rtc.RtcUtil;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ide.jobs.ClientActionItemsRefreshJob;
import com.smartbear.collaborator.ui.ide.jobs.ReviewFinishedHandler;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.swt.widgets.Shell;

public class RtcReviewFinishedHandler
extends ReviewFinishedHandler {
    static final Log LOG = LogFactory.getLog(RtcReviewFinishedHandler.class);
    private final IWorkItem workItem;

    public RtcReviewFinishedHandler(IWorkItem workItem) {
        this.workItem = workItem;
    }

    public void done(IJobChangeEvent event) {
        super.done(event);
        if (this.workItem == null) {
            return;
        }
        ITeamRepository repo = (ITeamRepository)this.workItem.getOrigin();
        if (event.getResult().getSeverity() != 4) {
            ClientActionItemsRefreshJob.INSTANCE.start();
            AddToReviewJob job = (AddToReviewJob)event.getJob();
            try {
                ReviewInfo reviewInfo = job.getReviewInfo();
                String reviewId = reviewInfo.getReviewId().toString();
                IWorkItemClient workItemClient = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
                IWorkItemWorkingCopyManager workingCopyManager = workItemClient.getWorkItemWorkingCopyManager();
                workingCopyManager.connect((IWorkItemHandle)this.workItem, IWorkItem.FULL_PROFILE, null);
                WorkItemWorkingCopy workItemCopy = workingCopyManager.getWorkingCopy((IWorkItemHandle)this.workItem);
                IEndPointDescriptor reviewLinkDescriptor = ILinkTypeRegistry.INSTANCE.getLinkType("com.smartbear.collaborator.rtc.process.relatedReview").getTargetEndPointDescriptor();
                for (IReference ref : workItemCopy.getReferences().getReferences(reviewLinkDescriptor)) {
                    if (!reviewId.equals(ref.getExtraInfo())) continue;
                    return;
                }
                String linkLabel = "Review #" + reviewId + " (created manually)";
                IURIReference reviewRef = IReferenceFactory.INSTANCE.createReferenceFromURI(RtcUtil.computeReviewURI((ReviewInfo)reviewInfo, (URL)Collaborator.getOptions().getUrl()), linkLabel, reviewId);
                workItemCopy.getReferences().add(reviewLinkDescriptor, (IReference)reviewRef);
                if (workItemCopy.isDirty()) {
                    IDetailedStatus status = workItemCopy.save(null);
                    if (!status.isOK()) {
                        LOG.error((Object)("Error saving updated work item:" + status.getMessage()));
                        LOG.error((Object)status.getDetails());
                    }
                } else {
                    LOG.debug((Object)"WorkItem was not changed.");
                }
                Location location = Location.namedLocation((IItem)this.workItem, (String)repo.publicUriRoot());
                String workItemUrl = location.toAbsoluteUri().toString();
                CommandCommentCreate command = new CommandCommentCreate();
                command.setComment(workItemUrl);
                command.setReview(reviewId);
                Collaborator.executeJson((Command)command, (UserInfo)job.getCurrentUserInfo(), (IScmOptions)new ScmOptions(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception ex) {
                StringBuilder message = new StringBuilder("Some errors occurred while creating review link for workItem\n");
                message.append(ex.getMessage());
                message.append(ex.getCause());
                CollaboratorUI.openWarning((Shell)CollaboratorUI.getShell(), (String)message.toString());
            }
        }
    }
}

