/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.resources;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.smartbear.ccollab.datamodel.client.DefectState;
import com.smartbear.ccollab.datamodel.client.IClientFile;
import com.smartbear.ccollab.datamodel.client.IClientFileDefect;
import com.smartbear.ccollab.datamodel.client.ILocator;
import com.smartbear.ccollab.datamodel.client.LineLocator;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.resources.LocatorMapper;
import com.smartbear.collaborator.resources.ResourcesUtil;
import com.smartbear.progress.IteratorWithProgress;
import com.smartbear.util.SmartBearUtils;
import com.smartbear.util.commons.ObjectUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public enum DefectMarkerUtils {

    private static final DefectState.IDefectStateVisitor<String> MARKER_TYPE_VISITOR = new DefectState.IDefectStateVisitor<String>(){

        public String visitOpen() {
            return "com.smartbear.collaborator.ide.opendefectmarker";
        }

        public String visitFixed() {
            return "com.smartbear.collaborator.ide.fixeddefectmarker";
        }

        public String visitReject() {
            return "com.smartbear.collaborator.ide.rejectdefectmarker";
        }

        public String visitExternal() {
            return "com.smartbear.collaborator.ide.externalizeddefectmarker";
        }
    };
    private static final String ATTR_REVIEW_ID = "reviewId";
    private static final String ATTR_DEFECT_ID = "defectId";
    private static final DefectState.IDefectStateVisitor<Integer> DEFECT_STATE_SEVERITY = new DefectState.IDefectStateVisitor<Integer>(){

        public Integer visitOpen() {
            return 2;
        }

        public Integer visitFixed() {
            return 0;
        }

        public Integer visitReject() {
            return 0;
        }

        public Integer visitExternal() {
            return 1;
        }
    };
    private static final Function<IClientFile, File> CLIENT_FILE_TO_LOCAL_FILE = new Function<IClientFile, File>(){

        public File apply(IClientFile file) {
            return file.getLocalFile();
        }
    };
    private static final Function<IClientFileDefect, Integer> DEFECT_TO_ID = new Function<IClientFileDefect, Integer>(){

        public Integer apply(IClientFileDefect defect) {
            return defect.getDefectId();
        }
    };
    private static final Function<IMarker, File> DEFECT_MARKER_TO_LOCAL_FILE = new Function<IMarker, File>(){

        public File apply(IMarker defectMarker) {
            return defectMarker.getResource().getLocation().toFile();
        }
    };
    private static final Function<IMarker, Integer> DEFECT_MARKER_TO_DEFECT_ID = new Function<IMarker, Integer>(){

        public Integer apply(IMarker defectMarker) {
            try {
                return (Integer)defectMarker.getAttribute(DefectMarkerUtils.ATTR_DEFECT_ID);
            }
            catch (CoreException e) {
                String msg = "Could not get defect attribute from defect marker " + defectMarker;
                Collaborator.log((String)msg, (Throwable)e);
                return -1;
            }
        }
    };

    public static void updateDefectMarkers(List<IClientFile> reviewFiles, IProgressMonitor monitor) {
        monitor.beginTask("Updating Markers", 100);
        monitor.subTask("Finding existing markers");
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        try {
            for (DefectState state : DefectState.values()) {
                markers.addAll(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().findMarkers((String)state.accept(MARKER_TYPE_VISITOR), false, 2)));
            }
        }
        catch (CoreException e) {
            RuntimeException ex = new RuntimeException("Could not get list of existing defect markers", e);
            Collaborator.log((Exception)ex);
            throw ex;
        }
        monitor.worked(1);
        ImmutableListMultimap markersByFile = Multimaps.index(markers, DEFECT_MARKER_TO_LOCAL_FILE);
        monitor.subTask("Deleting old markers");
        HashSet reviewLocalFiles = Sets.newHashSet((Iterable)Iterables.transform(reviewFiles, CLIENT_FILE_TO_LOCAL_FILE));
        for (File noLongerReviewedFile : Sets.difference((Set)markersByFile.keySet(), (Set)reviewLocalFiles)) {
            for (IMarker marker : markersByFile.get((Object)noLongerReviewedFile)) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    RuntimeException ex = new RuntimeException("Could not delete marker " + marker, e);
                    Collaborator.log((Exception)ex);
                    throw ex;
                }
            }
        }
        monitor.worked(1);
        IteratorWithProgress itr = IteratorWithProgress.getIterator(reviewFiles, (String)"updating markers", (IProgressMonitor)new SubProgressMonitor(monitor, 98), (int)4);
        for (IClientFile reviewFile : itr) {
            monitor.subTask("Updating markers for " + reviewFile.getLocalFile().getName());
            DefectMarkerUtils.updateDefectMarkers(reviewFile, (List)ObjectUtils.defaultIfNull((Object)markersByFile.get((Object)reviewFile.getLocalFile()), Collections.emptyList()), itr.getIterationProgressMonitor());
        }
        monitor.done();
    }

    private static void updateDefectMarkers(IClientFile reviewFile, List<IMarker> existingMarkers, IProgressMonitor monitor) {
        Map existingMarkersByDefect = SmartBearUtils.correlate((Iterable)reviewFile.getDefects(), DEFECT_TO_ID, existingMarkers, DEFECT_MARKER_TO_DEFECT_ID);
        for (IMarker marker : Iterables.filter(existingMarkers, (Predicate)Predicates.not((Predicate)Predicates.in(existingMarkersByDefect.values())))) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                RuntimeException ex = new RuntimeException("Could not delete marker " + marker, e);
                Collaborator.log((Exception)ex);
                throw ex;
            }
        }
        IFile file = ResourcesUtil.findFile(reviewFile.getLocalFile());
        if (file == null) {
            return;
        }
        if (!file.exists() || !file.getProject().isOpen()) {
            return;
        }
        monitor.subTask("Updating markers for " + file.getFullPath());
        Map promotedLocators = new LocatorMapper(file, reviewFile.getScmMaterials().getReviewId()).promoteToFile(reviewFile.getDefects(), monitor);
        for (IClientFileDefect defect : reviewFile.getDefects()) {
            DefectMarkerUtils.updateDefectMarker(file, defect, promotedLocators.get(defect), (IMarker)existingMarkersByDefect.get(defect));
        }
    }

    private static void updateDefectMarker(IFile localFile, IClientFileDefect defect, ILocator localLocator, IMarker marker) {
        if (marker == null) {
            try {
                marker = localFile.createMarker((String)defect.getState().accept(MARKER_TYPE_VISITOR));
            }
            catch (CoreException e) {
                RuntimeException ex = new RuntimeException("Could not create marker on file " + localFile, e);
                Collaborator.log((Exception)ex);
                throw ex;
            }
        }
        String type = (String)defect.getState().accept(MARKER_TYPE_VISITOR);
        try {
            if (!StringUtils.equals((String)marker.getType(), (String)type)) {
                IResource file = marker.getResource();
                marker.delete();
                marker = file.createMarker(type);
            }
        }
        catch (CoreException e) {
            RuntimeException ex = new RuntimeException("Could not recreate marker " + marker + " for defect " + defect, e);
            Collaborator.log((Exception)ex);
            throw ex;
        }
        DefectMarkerUtils.updateDefectMarker(marker, defect, localLocator);
    }

    private static void updateDefectMarker(IMarker marker, IClientFileDefect defect, ILocator localLocator) {
        if (!marker.exists()) {
            return;
        }
        try {
            marker.setAttribute(ATTR_REVIEW_ID, defect.getFile().getScmMaterials().getReviewId());
            marker.setAttribute(ATTR_DEFECT_ID, defect.getDefectId());
            marker.setAttribute("severity", defect.getState().accept(DEFECT_STATE_SEVERITY));
            marker.setAttribute("message", (Object)defect.getText());
            if (localLocator instanceof LineLocator) {
                marker.setAttribute("lineNumber", ((LineLocator)localLocator).getLineNumber());
            }
            marker.setAttribute("location", (Object)localLocator.toString());
        }
        catch (CoreException e) {
            RuntimeException ex = new RuntimeException("Could not set attributes on marker " + marker);
            Collaborator.log((Exception)ex);
            throw ex;
        }
    }
}

