/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.resources;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.datamodel.client.ILocator;
import com.smartbear.ccollab.datamodel.client.IVersionLocatable;
import com.smartbear.ccollab.datamodel.client.LineLocator;
import com.smartbear.ccollab.datamodel.diff.VersionDiffUtils;
import com.smartbear.ccollab.datamodel.displaymodel.LineLocatorPromoter;
import com.smartbear.collaborator.ClientContentManager;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.NotAllowedToAccessVersionContentException;
import com.smartbear.diffs.Diff;
import com.smartbear.util.DeepObject;
import com.smartbear.util.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class LocatorMapper {
    private static final Function<IVersionLocatable, VersionSpec> LOCATABLE_TO_VERSION = new Function<IVersionLocatable, VersionSpec>(){

        public VersionSpec apply(IVersionLocatable locatable) {
            return new VersionSpec(locatable.getOriginVersionId(), locatable.getOriginVersionContentMD5());
        }
    };
    private static final int WORK_LOAD_FROM_DISK = 10;
    private static final int WORK_DOWNLOAD_FROM_SERVER = 30;
    private static final int WORK_DIFF = 5;
    private final IFile file;
    private final int reviewId;
    private final Map<VersionSpec, DiffResult> diffCache = Maps.newHashMap();
    private long fileModificationStamp;
    private int fileContentLength;

    public LocatorMapper(IFile file, int reviewId) {
        this.file = file;
        this.reviewId = reviewId;
    }

    public IFile getFile() {
        return this.file;
    }

    public int getReviewId() {
        return this.reviewId;
    }

    public boolean isDifferentFromVersion(int versionId, String versionMd5, IProgressMonitor monitor) {
        VersionSpec version = new VersionSpec(versionId, versionMd5);
        this.cacheVersionDiffs(Collections.singleton(version), monitor);
        DiffResult diffResult = this.diffCache.get((Object)version);
        if (diffResult == null) {
            return true;
        }
        return diffResult.diffs.length > 0;
    }

    public <L extends IVersionLocatable> Map<L, ILocator> promoteToFile(Collection<L> locatables, IProgressMonitor monitor) {
        HashMap promotedLocatables = Maps.newHashMapWithExpectedSize((int)locatables.size());
        ArrayList lineLocatables = Lists.newArrayListWithExpectedSize((int)locatables.size());
        for (IVersionLocatable locatable : locatables) {
            ILocator originLocator = locatable.getOriginLocator();
            if (originLocator instanceof LineLocator) {
                lineLocatables.add(locatable);
                continue;
            }
            promotedLocatables.put(locatable, originLocator);
        }
        if (lineLocatables.isEmpty()) {
            return promotedLocatables;
        }
        HashSet versions = Sets.newHashSet((Iterable)Iterables.transform((Iterable)lineLocatables, LOCATABLE_TO_VERSION));
        this.cacheVersionDiffs(versions, monitor);
        promotedLocatables.putAll(this.promoteLineLocatorsCached(lineLocatables));
        return promotedLocatables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void cacheVersionDiffs(Set<VersionSpec> versions, IProgressMonitor monitor) {
        Sets.SetView versionsToDiff;
        if (this.file.getModificationStamp() != this.fileModificationStamp) {
            this.diffCache.clear();
        }
        if ((versionsToDiff = Sets.difference(versions, this.diffCache.keySet())).isEmpty()) {
            return;
        }
        int totalWork = 0;
        totalWork += 10;
        for (VersionSpec versionSpec : versionsToDiff) {
            if (!Collaborator.getContentManager().isCached(versionSpec.md5)) {
                totalWork += 30;
            }
            totalWork += 10;
            totalWork += 5;
        }
        monitor.beginTask("Promoting locations to local version of " + this.file.getFullPath(), totalWork);
        monitor.subTask("Reading local content");
        String[] localContent = null;
        String charset = null;
        BufferedReader reader = null;
        try {
            charset = this.file.getCharset();
            reader = new BufferedReader(new InputStreamReader(this.file.getContents(), charset));
            localContent = Strings.breakIntoLinesForDiff((Reader)reader);
            IOUtils.closeQuietly((Reader)reader);
            reader = null;
        }
        catch (IOException ex) {
            Collaborator.log((String)("Error reading content of file '" + this.file.getFullPath() + "'"), (Throwable)ex);
            return;
        }
        catch (CoreException ex2) {
            Collaborator.log((String)("Error promoting locations for file '" + this.file.getFullPath() + "'"), (Throwable)ex2);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeQuietly(reader);
            reader = null;
        }
        this.fileModificationStamp = this.file.getModificationStamp();
        this.fileContentLength = localContent.length;
        monitor.worked(10);
        for (VersionSpec version : versionsToDiff) {
            String[] versionContent = null;
            try {
                boolean contentCached = Collaborator.getContentManager().isCached(version.md5);
                if (!contentCached) {
                    monitor.subTask("Downloading version from server");
                }
                ClientContentManager.IContentAccessor versionContentAccessor = Collaborator.getContentManager().getContent(this.reviewId, version.id, version.md5, (IProgressMonitor)(contentCached ? new NullProgressMonitor() : new SubProgressMonitor(monitor, 30)));
                monitor.subTask("Reading version content");
                reader = new BufferedReader(new InputStreamReader(versionContentAccessor.getContent(), charset));
                versionContent = Strings.breakIntoLinesForDiff((Reader)reader);
                monitor.worked(10);
            }
            catch (CollabClientServerConnectivityException ex) {
                Collaborator.log((String)"Error connecting to server to download content", (Throwable)ex);
                continue;
            }
            catch (IOException ex) {
                Collaborator.log((String)("Error reading version content (" + version.id + ", " + version.md5 + ")"), (Throwable)ex);
                continue;
            }
            catch (NotAllowedToAccessVersionContentException ex) {
                Collaborator.log((String)("Not allowed to access version " + version.id), (Throwable)ex);
                continue;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
                reader = null;
                continue;
            }
            monitor.subTask("Comparing local content with version content");
            Diff[] diffs = VersionDiffUtils.computeDifferences((String[])versionContent, (String[])localContent, (boolean)false, (boolean)false, (boolean)false);
            this.diffCache.put(version, new DiffResult(diffs, versionContent.length));
            versionContent = null;
            monitor.worked(5);
        }
        monitor.done();
    }

    private <L extends IVersionLocatable> Map<L, ILocator> promoteLineLocatorsCached(Collection<L> locatables) {
        HashMap promotedLocatables = Maps.newHashMapWithExpectedSize((int)locatables.size());
        for (IVersionLocatable locatable : locatables) {
            VersionSpec versionSpec = new VersionSpec(locatable.getOriginVersionId(), locatable.getOriginVersionContentMD5());
            DiffResult diffResult = this.diffCache.get((Object)versionSpec);
            LineLocator originLocator = (LineLocator)locatable.getOriginLocator();
            Object promotedLocator = diffResult == null ? originLocator : LineLocatorPromoter.mapLocator((LineLocator)originLocator, (Diff[])diffResult.diffs, (int)diffResult.versionContentLength, (int)this.fileContentLength);
            promotedLocatables.put(locatable, promotedLocator);
        }
        return promotedLocatables;
    }

    private static class DiffResult
    extends DeepObject {
        public final Diff[] diffs;
        public final int versionContentLength;

        public DiffResult(Diff[] diffs, int versionContentLength) {
            this.diffs = diffs;
            this.versionContentLength = versionContentLength;
        }
    }

    private static class VersionSpec
    extends DeepObject {
        public final int id;
        public final String md5;

        public VersionSpec(int id, String md5) {
            this.id = id;
            this.md5 = md5;
        }
    }
}

