/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.resources;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.smartbear.ccollab.datamodel.client.IClientFile;
import com.smartbear.util.commons.ObjectUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

public class ResourcesUtil {
    public static final Predicate<IResource> CONTAINERS_PREDICATE = new Predicate<IResource>(){

        public boolean apply(IResource resource) {
            return resource instanceof IContainer;
        }
    };
    public static final Predicate<IResource> FILES_PREDICATE = new Predicate<IResource>(){

        public boolean apply(IResource resource) {
            return resource instanceof IFile;
        }
    };
    public static final Predicate<IResource> IN_OPEN_PROJECT_PREDICATE = new Predicate<IResource>(){

        public boolean apply(IResource resource) {
            return resource.getProject().isOpen();
        }
    };
    public static final Function<IResource, IProject> CONTAINING_PROJECT_FUNCTION = new Function<IResource, IProject>(){

        public IProject apply(IResource resource) {
            return resource.getProject();
        }
    };
    private static final QualifiedName REVIEW_FILES = new QualifiedName("com.smartbear.collaborator.ide", "reviewFiles");
    private static final QualifiedName REVIEW_FILE_ANCESTOR = new QualifiedName("com.smartbear.collaborator.ide", "reviewFileAncestor");

    private ResourcesUtil() {
    }

    public static Iterable<IContainer> filterContainers(Iterable<? extends IResource> resources) {
        return Iterables.filter(resources, CONTAINERS_PREDICATE);
    }

    public static Iterable<IFile> filterFiles(Iterable<? extends IResource> resources) {
        return Iterables.filter(resources, FILES_PREDICATE);
    }

    public static <R extends IResource> Iterable<R> filterInOpenProject(Iterable<R> resources) {
        return Iterables.filter(resources, IN_OPEN_PROJECT_PREDICATE);
    }

    public static List<IResource> toResources(List<ResourceMapping> resourceMappings) throws CoreException {
        LinkedList<IResource> resources = new LinkedList<IResource>();
        for (ResourceMapping resourceMapping : resourceMappings) {
            ResourceTraversal[] traversals = resourceMapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            for (int i = 0; i < traversals.length; ++i) {
                resources.addAll(Arrays.asList(traversals[i].getResources()));
            }
        }
        return resources;
    }

    public static Set<IProject> getContainingProjects(Iterable<? extends IResource> resources) {
        return Sets.newHashSet((Iterable)Iterables.transform(resources, CONTAINING_PROJECT_FUNCTION));
    }

    public static IFile findFile(File localFile) {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(localFile.getAbsolutePath()));
    }

    public static void updateResourceProperties(List<IClientFile> files) {
        HashMap fileResources = new HashMap(files.size());
        for (IClientFile iClientFile : files) {
            IFile fileResource = ResourcesUtil.findFile(iClientFile.getLocalFile());
            if (fileResource == null) continue;
            if (!fileResources.containsKey(fileResource)) {
                fileResources.put(fileResource, new HashSet(1));
            }
            ((Set)fileResources.get(fileResource)).add(iClientFile);
        }
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getType() != 1) {
                        if (proxy.getSessionProperty(REVIEW_FILE_ANCESTOR) != null) {
                            proxy.requestResource().setSessionProperty(REVIEW_FILE_ANCESTOR, null);
                            return true;
                        }
                        return false;
                    }
                    if (proxy.getSessionProperty(REVIEW_FILES) != null) {
                        proxy.requestResource().setSessionProperty(REVIEW_FILES, null);
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException e) {
            throw new RuntimeException("Error visiting resources", e);
        }
        for (Map.Entry entry : fileResources.entrySet()) {
            ResourcesUtil.setReviewFiles((IFile)entry.getKey(), (Set)entry.getValue());
        }
    }

    private static void setReviewFiles(IFile file, Set<IClientFile> files) {
        if (!file.exists() || !file.getProject().isOpen()) {
            return;
        }
        try {
            file.setSessionProperty(REVIEW_FILES, files.isEmpty() ? null : files);
        }
        catch (CoreException e) {
            throw new RuntimeException("Could not set file session property", e);
        }
        for (IContainer ancestor = file.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            try {
                ancestor.setSessionProperty(REVIEW_FILE_ANCESTOR, (Object)true);
                continue;
            }
            catch (CoreException e) {
                throw new RuntimeException("Could not set container session property", e);
            }
        }
    }

    public static Set<IClientFile> getReviewFiles(IFile file) {
        if (!file.exists() || !file.getProject().isOpen()) {
            return Collections.emptySet();
        }
        try {
            return (Set)ObjectUtils.defaultIfNull((Object)((Set)file.getSessionProperty(REVIEW_FILES)), Collections.emptySet());
        }
        catch (CoreException e) {
            throw new RuntimeException("Could not read file session property", e);
        }
    }
}

