/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.team;

import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.progress.IOUtilsWithProgress;
import com.smartbear.scm.IScmCommitInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;

public abstract class AbstractSyncInfoVersion
implements IScmCommitInfo {
    final SyncInfo syncInfo;
    final String serverPath;
    final String version;
    final IStorageAccessor storageAccessor;
    final String author;
    final Date date;
    final IScmCommitInfo.State state;

    public AbstractSyncInfoVersion(SyncInfo syncInfo, String serverPath, String version, IStorageAccessor storageAccessor, String author, Date date, IScmCommitInfo.State state) {
        this.syncInfo = syncInfo;
        this.serverPath = serverPath;
        this.version = version;
        this.storageAccessor = storageAccessor;
        this.author = author;
        this.date = date;
        this.state = state;
    }

    public IScmCommitInfo getCommitInfo(IProgressMonitor monitor) throws ScmCommunicationException {
        return this;
    }

    public byte[] getContent(int maxContentSize, IProgressMonitor monitor) throws ScmCommunicationException {
        byte[] content;
        monitor.beginTask("Extracting revision contents", 100);
        if (this.getState() == IScmCommitInfo.State.DELETING) {
            content = new byte[]{};
            monitor.worked(100);
        } else {
            InputStream contentStream = null;
            try {
                IStorage storage = this.storageAccessor.getStorage((IProgressMonitor)new SubProgressMonitor(monitor, 90));
                contentStream = storage.getContents();
                content = IOUtilsWithProgress.toByteArray((InputStream)contentStream, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            catch (CoreException e) {
                Collaborator.log((Exception)((Object)e));
                throw new ScmCommunicationException((Exception)((Object)e));
            }
            catch (IOException e) {
                Collaborator.log((Exception)e);
                throw new ScmCommunicationException((Exception)e);
            }
            finally {
                if (contentStream != null) {
                    try {
                        contentStream.close();
                    }
                    catch (IOException e) {
                        Collaborator.log((Exception)e);
                    }
                }
            }
        }
        monitor.done();
        return content;
    }

    public String getAtomicTransactionId() {
        return null;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getComment() {
        return "";
    }

    public Date getDate() {
        return this.date;
    }

    public IScmCommitInfo.State getState() {
        return this.state;
    }

    protected static interface IStorageAccessor {
        public IStorage getStorage(IProgressMonitor var1) throws ScmCommunicationException;
    }
}

