/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.team;

import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.team.IResourceScmClientConfiguration;
import com.smartbear.collaborator.team.IResourceScmLocalCheckout;
import com.smartbear.collaborator.team.ResourceScmClientConfiguration;
import com.smartbear.collaborator.team.none.NoneResourceScmClientConfiguration;
import com.smartbear.collaborator.team.scm.IResourceScmClientConfigurationFactory;
import com.smartbear.collections.Tuple;
import com.smartbear.progress.IteratorWithProgress;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.IScmConnectionParameters;
import com.smartbear.scm.IScmLocalCheckout;
import com.smartbear.scm.IScmSystem;
import com.smartbear.scm.IScmVersion;
import com.smartbear.scm.ScmConfigurationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.RepositoryProvider;

public class ClientConfigurationManager
extends ResourceScmClientConfiguration
implements IResourceScmClientConfiguration {
    private static final String CLIENT_CONFIG_FACTORY_EXTENSION_POINT = "com.smartbear.collaborator.ide.clientConfigurationProvider";
    private static final String REPOSITORY_PROVIDER_ID_ATTRIBUTE = "repositoryProviderId";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final Log LOG = LogFactory.getLog(ClientConfigurationManager.class);
    private static final IResourceScmClientConfiguration NONE_CLIENT_CONFIG = NoneResourceScmClientConfiguration.INSTANCE;
    private final Map<RepositoryProvider, IResourceScmClientConfiguration> providerToClientConfigCache = new HashMap<RepositoryProvider, IResourceScmClientConfiguration>();

    private static IResourceScmClientConfiguration getClientConfigFor(RepositoryProvider provider) throws ScmConfigurationException {
        IConfigurationElement[] factoryElements = Platform.getExtensionRegistry().getConfigurationElementsFor(CLIENT_CONFIG_FACTORY_EXTENSION_POINT);
        String providerId = provider.getID();
        IResourceScmClientConfigurationFactory clientConfigFactory = null;
        for (int i = 0; i < factoryElements.length; ++i) {
            String factoryProviderId = factoryElements[i].getAttribute(REPOSITORY_PROVIDER_ID_ATTRIBUTE);
            if (!providerId.equals(factoryProviderId)) continue;
            try {
                clientConfigFactory = (IResourceScmClientConfigurationFactory)factoryElements[i].createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                Collaborator.log((String)("Could not load IResourceScmClientConfigurationFactory for RepositoryProvider id: " + providerId), (Throwable)e);
            }
            break;
        }
        if (clientConfigFactory == null) {
            Collaborator.log((String)("Could not find client configuration factory for RepositoryProvider id: " + providerId));
            return NONE_CLIENT_CONFIG;
        }
        return clientConfigFactory.getClientConfiguration(provider, (IProgressMonitor)new NullProgressMonitor());
    }

    private IResourceScmClientConfiguration clientConfigFor(IResource resource) throws ScmConfigurationException {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject());
        if (provider == null) {
            return NONE_CLIENT_CONFIG;
        }
        if (!this.providerToClientConfigCache.containsKey(provider)) {
            this.providerToClientConfigCache.put(provider, ClientConfigurationManager.getClientConfigFor(provider));
        }
        return this.providerToClientConfigCache.get(provider);
    }

    public boolean isSupportedSCM(RepositoryProvider provider) throws ScmConfigurationException {
        IResourceScmClientConfiguration clientConfig;
        if (provider == null) {
            return true;
        }
        if (!this.providerToClientConfigCache.containsKey(provider)) {
            this.providerToClientConfigCache.put(provider, ClientConfigurationManager.getClientConfigFor(provider));
        }
        return (clientConfig = this.providerToClientConfigCache.get(provider)) != NONE_CLIENT_CONFIG;
    }

    public IScmChangelist getChangelist(String id, IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public String getDisplayableConfiguration() {
        throw new UnsupportedOperationException();
    }

    public IScmChangelist[] getLocalChangelists(IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    @Override
    public IResourceScmLocalCheckout getLocalCheckout(IFile file, IProgressMonitor monitor) throws ScmCommunicationException {
        try {
            return this.clientConfigFor((IResource)file).getLocalCheckout(file, monitor);
        }
        catch (ScmConfigurationException e) {
            throw new ScmCommunicationException((Exception)((Object)e));
        }
    }

    public IScmVersion getVersion(Tuple<String> versionSpec, IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    @Override
    public List<IResourceScmLocalCheckout> getModifiedFiles(IContainer container, IProgressMonitor monitor) throws ScmCommunicationException {
        try {
            return this.clientConfigFor((IResource)container).getModifiedFiles(container, monitor);
        }
        catch (ScmConfigurationException e) {
            throw new ScmCommunicationException((Exception)((Object)e));
        }
    }

    public IScmSystem getScmSystem() {
        throw new UnsupportedOperationException("Composite IScmClientConfiguration has multiple IScmSystems");
    }

    public IScmConnectionParameters getServerConfiguration(IScmLocalCheckout checkout, IScmVersion version, IScmChangelist atomicChange) throws ScmConfigurationException {
        throw new UnsupportedOperationException("Composite IScmClientConfiguration has multiple server configuration strings");
    }

    public String getUserName() {
        throw new UnsupportedOperationException("Composite IScmClientConfiguration has multiple usernames");
    }

    public void logStatus(IProgressMonitor monitor) throws ScmCommunicationException {
        LOG.debug((Object)("CompositeScmClientConiguration managing " + this.providerToClientConfigCache.values().size() + " IScmClientConfiguration(s)"));
        LOG.debug(this.providerToClientConfigCache);
        IteratorWithProgress itr = IteratorWithProgress.getIterator(this.providerToClientConfigCache.values(), (String)"Logging", (IProgressMonitor)monitor);
        while (itr.hasNext()) {
            ((IResourceScmClientConfiguration)itr.next()).logStatus(itr.getIterationProgressMonitor());
        }
        monitor.done();
    }

    public void setConfiguration(Properties params, boolean forceCurrent) throws ScmConfigurationException {
        throw new UnsupportedOperationException("Cannot set configuration on Composite IScmClientConfiguration");
    }
}

