/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.team;

import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.team.IResourceScmClientConfiguration;
import com.smartbear.collaborator.team.IResourceScmLocalCheckout;
import com.smartbear.collaborator.team.ResourceScmClientConfiguration;
import com.smartbear.collaborator.team.ResourceScmLocalCheckoutWrapper;
import com.smartbear.collections.Tuple;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.IScmConnectionParameters;
import com.smartbear.scm.IScmLocalCheckout;
import com.smartbear.scm.IScmSystem;
import com.smartbear.scm.IScmVersion;
import com.smartbear.scm.ScmConfigurationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ResourceScmClientConfigurationWrapper
extends ResourceScmClientConfiguration
implements IResourceScmClientConfiguration {
    private final IScmClientConfiguration clientConfig;

    public ResourceScmClientConfigurationWrapper(IScmClientConfiguration clientConfig) {
        this.clientConfig = clientConfig;
    }

    public IScmClientConfiguration getWrappedClientConfig() {
        return this.clientConfig;
    }

    @Override
    public IResourceScmLocalCheckout getLocalCheckout(IFile file, IProgressMonitor monitor) throws ScmCommunicationException {
        File path = file.getLocation().toFile();
        IScmLocalCheckout localCheckout = this.clientConfig.getLocalCheckout(path, monitor);
        return localCheckout == null ? null : new ResourceScmLocalCheckoutWrapper(localCheckout, file);
    }

    public static List<IResourceScmLocalCheckout> wrapperCheckouts(Collection<IScmLocalCheckout> checkouts, IContainer ancestor) {
        int ancestorPathSegments = ancestor.getLocation().segmentCount();
        ArrayList<IResourceScmLocalCheckout> resourceCheckouts = new ArrayList<IResourceScmLocalCheckout>(checkouts.size());
        for (IScmLocalCheckout checkout : checkouts) {
            File path = checkout.getLocalPath();
            IPath relativePath = new Path(path.getAbsolutePath()).removeFirstSegments(ancestorPathSegments);
            IFile file = ancestor.getFile(relativePath);
            resourceCheckouts.add(new ResourceScmLocalCheckoutWrapper(checkout, file));
        }
        return resourceCheckouts;
    }

    @Override
    public List<IResourceScmLocalCheckout> getModifiedFiles(IContainer container, IProgressMonitor monitor) throws ScmCommunicationException {
        File directory = container.getLocation().toFile();
        List checkouts = this.clientConfig.getModifiedFiles(directory, monitor);
        if (checkouts == null) {
            return Collections.emptyList();
        }
        return ResourceScmClientConfigurationWrapper.wrapperCheckouts(checkouts, container);
    }

    public IScmVersion getVersion(Tuple<String> versionSpec, IProgressMonitor monitor) throws ScmCommunicationException {
        return this.clientConfig.getVersion(versionSpec, monitor);
    }

    public IScmChangelist getChangelist(String id, IProgressMonitor monitor) throws ScmCommunicationException {
        return this.clientConfig.getChangelist(id, monitor);
    }

    public String getDisplayableConfiguration() {
        return this.clientConfig.getDisplayableConfiguration();
    }

    public IScmChangelist[] getLocalChangelists(IProgressMonitor monitor) throws ScmCommunicationException {
        return this.clientConfig.getLocalChangelists(monitor);
    }

    public IScmSystem getScmSystem() {
        return this.clientConfig.getScmSystem();
    }

    public IScmConnectionParameters getServerConfiguration(IScmLocalCheckout checkout, IScmVersion version, IScmChangelist atomicChange) throws ScmCommunicationException, ScmConfigurationException {
        return this.clientConfig.getServerConfiguration(checkout, version, atomicChange);
    }

    public String getUserName() {
        return this.clientConfig.getUserName();
    }

    public void logStatus(IProgressMonitor monitor) throws ScmCommunicationException {
        this.clientConfig.logStatus(monitor);
    }
}

