/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.team;

import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.team.IResourceScmClientConfiguration;
import com.smartbear.collaborator.team.IResourceScmLocalCheckout;
import com.smartbear.collaborator.team.ResourceScmClientConfiguration;
import com.smartbear.collaborator.team.SyncInfoScmLocalCheckout;
import com.smartbear.collections.Tuple;
import com.smartbear.scm.IScmCommitInfo;
import com.smartbear.scm.IScmVersion;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariant;

public abstract class SubscriberClientConfiguration
extends ResourceScmClientConfiguration
implements IResourceScmClientConfiguration {
    private static final Log LOG = LogFactory.getLog(SubscriberClientConfiguration.class);
    protected Subscriber subscriber;

    public SubscriberClientConfiguration(Subscriber subscriber) {
        this.subscriber = subscriber;
    }

    protected abstract boolean isIgnored(IFile var1) throws ScmCommunicationException;

    protected abstract String getDisplayPath(IFile var1) throws ScmCommunicationException;

    protected String getAuthor() {
        return this.getUserName();
    }

    protected abstract String getAuthor(IResourceVariant var1, IProgressMonitor var2) throws ScmCommunicationException;

    protected abstract Date getDate(IResourceVariant var1, IProgressMonitor var2) throws ScmCommunicationException;

    protected abstract IScmCommitInfo.State getState(IResourceVariant var1, IProgressMonitor var2) throws ScmCommunicationException;

    public String getRevision(IResourceVariant resourceVariant) {
        return resourceVariant.getContentIdentifier();
    }

    public IScmVersion getVersion(Tuple<String> versionSpec, IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    @Override
    public IResourceScmLocalCheckout getLocalCheckout(IFile file, IProgressMonitor monitor) throws ScmCommunicationException {
        SyncInfo syncInfo;
        if (this.isIgnored(file)) {
            return null;
        }
        try {
            syncInfo = this.subscriber.getSyncInfo((IResource)file);
        }
        catch (TeamException e) {
            throw new ScmCommunicationException("Could not get SyncInfo", (Throwable)e);
        }
        if (syncInfo == null) {
            throw new ScmCommunicationException("Could not get Sync Info for file " + file);
        }
        return SyncInfoScmLocalCheckout.createLocal(this, syncInfo, monitor);
    }

    @Override
    public List<IResourceScmLocalCheckout> getModifiedFiles(IContainer container, IProgressMonitor monitor) throws ScmCommunicationException {
        IResource[] containers;
        monitor.beginTask("Getting modified files", 100);
        if (container.getType() == 8) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            ArrayList<IProject> openProjects = new ArrayList<IProject>(projects.length);
            for (int i = 0; i < projects.length; ++i) {
                if (!projects[i].isOpen()) continue;
                openProjects.add(projects[i]);
            }
            containers = openProjects.toArray(new IResource[openProjects.size()]);
        } else {
            containers = new IResource[]{container};
        }
        SyncInfoSet syncInfoSet = new SyncInfoSet();
        this.subscriber.collectOutOfSync(containers, 2, syncInfoSet, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
        syncInfoSet.rejectNodes(new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                return info.getLocal().getType() != 1;
            }
        });
        syncInfoSet.rejectNodes((FastSyncInfoFilter)new FastSyncInfoFilter.SyncInfoDirectionFilter(8));
        SyncInfo[] syncInfos = syncInfoSet.getSyncInfos();
        SubProgressMonitor checkoutMonitor = new SubProgressMonitor(monitor, 10);
        checkoutMonitor.beginTask("Getting local checkouts for modified files", 100 * syncInfos.length);
        ArrayList<IResourceScmLocalCheckout> localCheckouts = new ArrayList<IResourceScmLocalCheckout>(syncInfos.length);
        for (SyncInfo syncInfo : syncInfos) {
            localCheckouts.add(this.getLocalCheckout((IFile)syncInfo.getLocal(), (IProgressMonitor)new SubProgressMonitor(monitor, 100)));
        }
        return localCheckouts;
    }

    public void logStatus(IProgressMonitor monitor) throws ScmCommunicationException {
        LOG.debug((Object)this.subscriber);
    }
}

