/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.team;

import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.team.AbstractSyncInfoVersion;
import com.smartbear.collaborator.team.IResourceScmLocalCheckout;
import com.smartbear.collaborator.team.SubscriberClientConfiguration;
import com.smartbear.collaborator.team.SyncInfoScmVersion;
import com.smartbear.scm.IScmCommitInfo;
import com.smartbear.scm.IScmVersion;
import com.smartbear.scm.ScmUtils;
import java.io.File;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;

public class SyncInfoScmLocalCheckout
extends AbstractSyncInfoVersion
implements IResourceScmLocalCheckout {
    private final SubscriberClientConfiguration clientConfig;

    private SyncInfoScmLocalCheckout(SubscriberClientConfiguration clientConfig, SyncInfo syncInfo, String serverPath, String version, AbstractSyncInfoVersion.IStorageAccessor storageAccessor, String author, Date date, IScmCommitInfo.State state) {
        super(syncInfo, serverPath, version, storageAccessor, author, date, state);
        this.clientConfig = clientConfig;
    }

    public static SyncInfoScmLocalCheckout createLocal(SubscriberClientConfiguration clientConfig, final SyncInfo syncInfo, IProgressMonitor monitor) throws ScmCommunicationException {
        IScmCommitInfo.State state;
        String serverPath = clientConfig.getDisplayPath((IFile)syncInfo.getLocal());
        if (SyncInfo.getDirection((int)syncInfo.getKind()) == 8) {
            state = IScmCommitInfo.State.CONTROLLED;
        } else {
            switch (SyncInfo.getChange((int)syncInfo.getKind())) {
                case 0: {
                    state = IScmCommitInfo.State.CONTROLLED;
                    break;
                }
                case 1: {
                    state = IScmCommitInfo.State.ADDING;
                    break;
                }
                case 2: {
                    state = IScmCommitInfo.State.DELETING;
                    break;
                }
                case 3: {
                    state = IScmCommitInfo.State.INTEGRATING;
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognized change kind");
                }
            }
        }
        AbstractSyncInfoVersion.IStorageAccessor localStorageAccessor = new AbstractSyncInfoVersion.IStorageAccessor(){

            @Override
            public IStorage getStorage(IProgressMonitor monitor) {
                return (IFile)syncInfo.getLocal();
            }
        };
        return new SyncInfoScmLocalCheckout(clientConfig, syncInfo, serverPath, syncInfo.getLocalContentIdentifier(), localStorageAccessor, clientConfig.getAuthor(), new Date(), state);
    }

    public SubscriberClientConfiguration getClientConfiguration() {
        return this.clientConfig;
    }

    public File getLocalPath() {
        return this.getLocalResource().getLocation().toFile();
    }

    public String getDepotPath(IProgressMonitor monitor) throws ScmCommunicationException {
        return this.serverPath;
    }

    @Override
    public IFile getLocalResource() {
        return (IFile)this.syncInfo.getLocal();
    }

    public boolean isLocallyModified(IProgressMonitor monitor) throws ScmCommunicationException {
        return SyncInfo.getDirection((int)this.syncInfo.getKind()) != 8 && SyncInfo.getChange((int)this.syncInfo.getKind()) != 0;
    }

    public IScmVersion getBaseVersion(IProgressMonitor monitor) throws ScmCommunicationException {
        SyncInfoScmVersion baseVersion = this.syncInfo.getBase() != null ? SyncInfoScmVersion.createBase(this.getClientConfiguration(), this.syncInfo, monitor) : null;
        return baseVersion;
    }

    public String getLocalVersionName(IProgressMonitor monitor) throws ScmCommunicationException {
        return this.version;
    }

    public IScmCommitInfo.State getState(IProgressMonitor monitor) throws ScmCommunicationException {
        return this.getState();
    }

    public byte[] getLocalContent(int maxContentSize, IProgressMonitor monitor) throws ScmCommunicationException {
        return ScmUtils.getFileContent((File)this.getLocalPath(), (int)maxContentSize, (IProgressMonitor)monitor);
    }
}

