/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.team;

import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.team.AbstractSyncInfoVersion;
import com.smartbear.collaborator.team.SubscriberClientConfiguration;
import com.smartbear.scm.IScmCommitInfo;
import com.smartbear.scm.IScmVersion;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;

public class SyncInfoScmVersion
extends AbstractSyncInfoVersion
implements IScmVersion {
    final SubscriberClientConfiguration clientConfig;

    public SyncInfoScmVersion(SubscriberClientConfiguration clientConfig, SyncInfo syncInfo, String serverPath, String version, AbstractSyncInfoVersion.IStorageAccessor storageAccessor, String author, Date date, IScmCommitInfo.State state) {
        super(syncInfo, serverPath, version, storageAccessor, author, date, state);
        this.clientConfig = clientConfig;
    }

    static SyncInfoScmVersion createBase(SubscriberClientConfiguration clientConfig, final SyncInfo syncInfo, IProgressMonitor monitor) throws ScmCommunicationException {
        final String serverPath = clientConfig.getDisplayPath((IFile)syncInfo.getLocal());
        AbstractSyncInfoVersion.IStorageAccessor baseStorageAccessor = new AbstractSyncInfoVersion.IStorageAccessor(){

            @Override
            public IStorage getStorage(IProgressMonitor monitor) throws ScmCommunicationException {
                IStorage baseStorage;
                try {
                    baseStorage = syncInfo.getBase().getStorage(monitor);
                }
                catch (TeamException e) {
                    throw new ScmCommunicationException("Could not get base content of " + serverPath, (Throwable)e);
                }
                return baseStorage;
            }
        };
        monitor.beginTask("Loading information about base revision", 100);
        IResourceVariant base = syncInfo.getBase();
        String baseAuthor = clientConfig.getAuthor(base, (IProgressMonitor)new SubProgressMonitor(monitor, 33));
        Date baseDate = clientConfig.getDate(base, (IProgressMonitor)new SubProgressMonitor(monitor, 33));
        String baseRevision = clientConfig.getRevision(base);
        IScmCommitInfo.State baseState = clientConfig.getState(base, (IProgressMonitor)new SubProgressMonitor(monitor, 33));
        monitor.done();
        return new SyncInfoScmVersion(clientConfig, syncInfo, serverPath, baseRevision, baseStorageAccessor, baseAuthor, baseDate, baseState);
    }

    public SubscriberClientConfiguration getClientConfiguration() {
        return this.clientConfig;
    }

    public String getDepotPath() {
        return this.serverPath;
    }

    public String getFullyQualifiedVersion() {
        return this.version;
    }

    public List<IScmVersion> getHistory(int numVersions, IProgressMonitor monitor) throws ScmCommunicationException {
        return Collections.singletonList(this);
    }

    public File getLocalPath() {
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isLocalVersion() {
        return false;
    }
}

