/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.team.none;

import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.team.IResourceScmLocalCheckout;
import com.smartbear.collaborator.team.none.NoneResourceScmClientConfiguration;
import com.smartbear.progress.IOUtilsWithProgress;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.IScmCommitInfo;
import com.smartbear.scm.IScmVersion;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class NoneResourceScmLocalCheckout
implements IResourceScmLocalCheckout {
    private final IFile file;

    NoneResourceScmLocalCheckout(IFile file) {
        this.file = file;
    }

    public IScmClientConfiguration getClientConfiguration() {
        return NoneResourceScmClientConfiguration.INSTANCE;
    }

    public File getLocalPath() {
        if (this.file.getLocation() != null) {
            return this.file.getLocation().toFile();
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public byte[] getLocalContent(int maxContentSize, IProgressMonitor monitor) throws ScmCommunicationException {
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(this.file.getContents(true));
        }
        catch (CoreException e) {
            throw new ScmCommunicationException("Error accessing contents of " + this.file, (Throwable)e);
        }
        if (maxContentSize <= 0) {
            maxContentSize = -1;
        }
        byte[] e = IOUtilsWithProgress.toByteArray((InputStream)inputStream, (int)maxContentSize, (IProgressMonitor)monitor);
        IOUtils.closeQuietly((InputStream)inputStream);
        return e;
        {
            catch (IOException e2) {
                try {
                    throw new ScmCommunicationException("Error reading contents of " + this.file, (Throwable)e2);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
        }
    }

    public String getDepotPath(IProgressMonitor monitor) throws ScmCommunicationException {
        if (this.file.getLocation() != null) {
            return this.file.getLocation().toFile().getAbsolutePath();
        }
        return this.file.getLocationURI().toString();
    }

    public String getLocalVersionName(IProgressMonitor monitor) throws ScmCommunicationException {
        return "Uncontrolled file";
    }

    public IScmVersion getBaseVersion(IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public IScmCommitInfo.State getState(IProgressMonitor monitor) throws ScmCommunicationException {
        return IScmCommitInfo.State.UNCONTROLLED;
    }

    public boolean isLocallyModified(IProgressMonitor monitor) throws ScmCommunicationException {
        return false;
    }

    @Override
    public IFile getLocalResource() {
        return this.file;
    }
}

