/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.team.scm;

import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.team.scm.NeverEqualComparator;
import com.smartbear.collaborator.team.scm.NullResourceVariant;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.IScmLocalCheckout;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;

public class ScmSubscriber
extends Subscriber {
    IScmClientConfiguration clientConfig;
    IResource[] roots;
    Map<IResource, SyncInfo> resourceToSyncInfo;
    List<IResource> deletedFiles;

    public ScmSubscriber(IResource checkoutLink, IScmClientConfiguration clientConfig) {
        this.roots = new IResource[]{checkoutLink};
        this.clientConfig = clientConfig;
        try {
            this.refresh(null, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (TeamException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return "Collaborator - this string is not displayed anywhere?";
    }

    public IResourceVariantComparator getResourceComparator() {
        return NeverEqualComparator.INSTANCE;
    }

    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        return this.resourceToSyncInfo.get(resource);
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        return true;
    }

    public IResource[] members(IResource resource) throws TeamException {
        LinkedList<IResource> members = new LinkedList<IResource>();
        if (resource instanceof IContainer) {
            try {
                members.addAll(Arrays.asList(((IContainer)resource).members()));
            }
            catch (CoreException e) {
                throw new TeamException(e.getStatus());
            }
        }
        for (IResource deleted : this.deletedFiles) {
            if (!resource.equals((Object)deleted.getParent())) continue;
            members.add(deleted);
        }
        return members.toArray(new IResource[members.size()]);
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        if (this.resourceToSyncInfo == null) {
            try {
                this.resourceToSyncInfo = new HashMap<IResource, SyncInfo>();
                this.deletedFiles = new LinkedList<IResource>();
                List modifiedFiles = this.clientConfig.getModifiedFiles(this.roots[0].getLocation().toFile(), monitor);
                for (IScmLocalCheckout modifiedFile : modifiedFiles) {
                    File file = modifiedFile.getLocalPath();
                    IResource resource = ScmSubscriber.resourceFor(file.getAbsolutePath());
                    if (!resource.exists()) {
                        this.deletedFiles.add(resource);
                    }
                    NullResourceVariant remote = null;
                    if (modifiedFile.getBaseVersion((IProgressMonitor)new NullProgressMonitor()) != null) {
                        remote = NullResourceVariant.INSTANCE;
                    }
                    SyncInfo syncInfo = new SyncInfo(resource, null, (IResourceVariant)remote, (IResourceVariantComparator)NeverEqualComparator.INSTANCE);
                    syncInfo.init();
                    this.resourceToSyncInfo.put(resource, syncInfo);
                }
            }
            catch (Exception e) {
                Collaborator.log((String)"Could not refresh SCM server state", (Throwable)e);
                throw new TeamException("Could not refresh SCM server state", (Throwable)e);
            }
        }
    }

    public IResource[] roots() {
        return this.roots;
    }

    private static IResource resourceFor(String pathString) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(pathString);
        if (path.toFile().isDirectory()) {
            return workspaceRoot.findContainersForLocation((IPath)path)[0];
        }
        return workspaceRoot.findFilesForLocation((IPath)path)[0];
    }
}

