/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc.process;

import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.service.async.AbstractPostOutermostTransactionTask;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewInfo;
import com.smartbear.collaborator.json.interfaces.user.response.UserInfo;
import com.smartbear.collaborator.rtc.process.Configuration;
import com.smartbear.collaborator.rtc.process.ConnectionInfo;
import com.smartbear.collaborator.rtc.process.ICollaboratorService;
import com.smartbear.collaborator.rtc.process.RtcChangeSet;
import com.smartbear.collaborator.rtc.process.RtcConfig;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.eclipse.emf.ecore.EObject;

public class AddChangeSetToLinkedReviewTask
extends AbstractPostOutermostTransactionTask {
    public static final String TASK_ID = "com.smartbear.collaborator.rtc.process.addChangeSetToLinkedReviewTask";

    public String getTaskId() {
        return TASK_ID;
    }

    public void transactionFailed(EObject[] data) {
    }

    public void transactionSucceeded(EObject[] data, boolean wasReadOnly) {
        try {
            this.doAddChangeLists(data);
        }
        catch (Exception e) {
            this.getLog().error((Object)"Exception while adding a changeset to linked review:", (Throwable)e);
        }
    }

    private void doAddChangeLists(EObject[] data) throws TeamRepositoryException, CollabClientException {
        ICollaboratorService collab = ((ICollaboratorService)this.getService(ICollaboratorService.class)).getActualService();
        Log log = this.getLog();
        IChangeSet changeSet = (IChangeSet)data[0];
        IWorkItem workItem = (IWorkItem)data[1];
        Configuration config = (Configuration)data[2];
        ConnectionInfo connection = config.getConnectionInfo();
        int retries = config.getRetries() == null || config.getRetries() < 1 ? 1 : config.getRetries();
        int delayMs = config.getRetryDelayMs() == null || config.getRetryDelayMs() < 0 ? 0 : config.getRetryDelayMs();
        RtcChangeSet scmChangeSet = null;
        RtcConfig rtcConfig = collab.newRtcConfig();
        int attempt = 0;
        while (attempt++ < retries && (scmChangeSet = this.wrapChangeSet(changeSet, workItem, rtcConfig, collab)) == null) {
            if (attempt >= retries) continue;
            log.info((Object)("Change Set link was not found in Work Item " + workItem.getId() + ", retrying in " + delayMs + " ms"));
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (scmChangeSet == null) {
            log.error((Object)"Failed to find link to changeset. You may need to increase the number of retries or the delay before each retry in the follow-up configuration source view.");
            return;
        }
        UserInfo login = collab.jsonLogin(connection);
        ReviewInfo review = collab.findReview(connection, workItem);
        collab.addChangelists(connection, review, login, scmChangeSet.getClientConfiguration(), Collections.singleton(scmChangeSet));
    }

    private RtcChangeSet wrapChangeSet(IChangeSet changeSet, IWorkItem workItem, RtcConfig config, ICollaboratorService collab) throws TeamRepositoryException {
        RtcChangeSet scmChangeSet = null;
        ILinkCollection links = collab.findWorkItemChangeSetLinks(workItem);
        for (ILink link : links) {
            IItemHandle handle;
            IReference ref = link.getSourceRef();
            if (!ref.isItemReference() || !changeSet.sameItemId(handle = (IItemHandle)ref.resolve()) || (scmChangeSet = collab.wrapReferencedChangeSet(config, ref)) == null) continue;
            return scmChangeSet;
        }
        return null;
    }
}

