/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc.process;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.runtime.IOperationParticipant;
import com.ibm.team.process.common.advice.runtime.IParticipantInfoCollector;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.service.AbstractService;
import com.ibm.team.repository.service.IRepositoryItemService;
import com.ibm.team.repository.service.ITransactionService;
import com.ibm.team.scm.common.process.SaveClosedChangeSetOperationData;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.smartbear.collaborator.rtc.process.Configuration;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;

public class ChangeSetModifiedOperationParticipant
extends AbstractService
implements IOperationParticipant {
    public void run(AdvisableOperation operation, IProcessConfigurationElement participantConfig, IParticipantInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object rawOpData = operation.getOperationData();
        if (!(rawOpData instanceof SaveClosedChangeSetOperationData)) {
            return;
        }
        Log log = this.getLog();
        ArrayList<IWorkItemHandle> workItemHandles = new ArrayList<IWorkItemHandle>();
        SaveClosedChangeSetOperationData data = (SaveClosedChangeSetOperationData)rawOpData;
        Configuration config = Configuration.create(participantConfig);
        switch (data.getChangeType()) {
            case ADD_LINK: {
                for (IItemHandle handle : data.getLinks()) {
                    if (!(handle instanceof IWorkItemHandle)) continue;
                    workItemHandles.add((IWorkItemHandle)handle);
                }
                break;
            }
        }
        if (workItemHandles.size() == 0) {
            log.debug((Object)"No Work Items Added");
            return;
        }
        IRepositoryItemService ris = (IRepositoryItemService)this.getService(IRepositoryItemService.class);
        IItem[] items = ris.fetchItems(workItemHandles.toArray(new IItemHandle[0]), IRepositoryItemService.COMPLETE);
        ITransactionService transactionService = (ITransactionService)this.getService(ITransactionService.class);
        for (IItem workItem : items) {
            log.debug((Object)"ChangeSetModifiedOperationParticipant starting add approvals to review task");
            transactionService.executeTaskAfterCurrentOutermostTransaction("com.smartbear.collaborator.rtc.process", "com.smartbear.collaborator.rtc.process.addChangeSetToLinkedReviewTask", new EObject[]{(EObject)data.getChangeSet(), (EObject)workItem, config});
        }
    }
}

