/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc.process;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.ILinkQueryPage;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.common.service.ILinkService;
import com.ibm.team.links.service.ILinkServiceLibrary;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.service.IContributorService;
import com.ibm.team.repository.service.AbstractService;
import com.ibm.team.repository.service.IRepositoryItemService;
import com.ibm.team.repository.service.IServerDescriptionService;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.service.IServerSideVersionedContentService;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.service.IWorkItemServer;
import com.smartbear.beans.GlobalOptions;
import com.smartbear.beans.IGlobalOptions;
import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.ISettableGlobalOptions;
import com.smartbear.beans.ScmOptions;
import com.smartbear.ccollab.client.ICollabClientInterface;
import com.smartbear.ccollab.client.LoginUtils;
import com.smartbear.ccollab.client.NullClient;
import com.smartbear.ccollab.client.commands.CommandAddChangelist;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewCreate;
import com.smartbear.ccollab.client.commands.admin.review.CommandReviewEdit;
import com.smartbear.ccollab.client.commands.admin.review.participant.CommandParticipantAssign;
import com.smartbear.ccollab.client.commands.argrefs.ChangelistRefByObject;
import com.smartbear.ccollab.client.commands.argrefs.IChangelistRef;
import com.smartbear.ccollab.client.commands.argrefs.IRoleRef;
import com.smartbear.ccollab.client.commands.argrefs.IUserRef;
import com.smartbear.ccollab.client.commands.argrefs.RoleRefBySystemName;
import com.smartbear.ccollab.client.commands.argrefs.UserRefByLogin;
import com.smartbear.ccollab.datamodel.client.Phase;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.JsonAPIHandler;
import com.smartbear.collaborator.JsonBatchCommand;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.json.api.CollaboratorJsonApi;
import com.smartbear.collaborator.json.interfaces.review.ReviewPhase;
import com.smartbear.collaborator.json.interfaces.review.response.Assignment;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewInfo;
import com.smartbear.collaborator.json.interfaces.review.response.Role;
import com.smartbear.collaborator.json.interfaces.user.response.UserInfo;
import com.smartbear.collaborator.rtc.RtcUtil;
import com.smartbear.collaborator.rtc.process.Configuration;
import com.smartbear.collaborator.rtc.process.ConnectionInfo;
import com.smartbear.collaborator.rtc.process.ICollaboratorService;
import com.smartbear.collaborator.rtc.process.RtcChangeSet;
import com.smartbear.collaborator.rtc.process.RtcConfig;
import com.smartbear.collaborator.rtc.process.RtcWorkItem;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.util.SmartBearUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CollaboratorService
extends AbstractService
implements ICollaboratorService {
    private static final String CHANGE_SET_WORKSPACE_HINT_PREFIX = "Workspace=";
    private static final int CHANGE_SET_WORKSPACE_HINT_PREFIX_LENGTH = "Workspace=".length();
    private IGlobalOptions options;
    private ILinkService linkService;
    private ILinkServiceLibrary linkServiceLibrary;
    private IReferenceFactory referenceFactory;
    private IRepositoryItemService repositoryItemService;
    private IServerSideVersionedContentService serverSideVersionedContentService;
    private IServerDescriptionService serverDescriptionService;
    private IScmService scmService;
    private IContributorService contributorService;
    private IWorkItemServer workItemServer;

    protected void activate() {
        this.linkService = (ILinkService)this.getService(ILinkService.class);
        this.linkServiceLibrary = (ILinkServiceLibrary)this.linkService.getServiceLibrary(ILinkServiceLibrary.class);
        this.referenceFactory = this.linkServiceLibrary.referenceFactory();
        this.repositoryItemService = (IRepositoryItemService)this.getService(IRepositoryItemService.class);
        this.serverSideVersionedContentService = (IServerSideVersionedContentService)this.getService(IServerSideVersionedContentService.class);
        this.serverDescriptionService = (IServerDescriptionService)this.getService(IServerDescriptionService.class);
        this.scmService = (IScmService)this.getService(IScmService.class);
        this.contributorService = (IContributorService)this.getService(IContributorService.class);
        this.workItemServer = (IWorkItemServer)this.getService(IWorkItemServer.class);
        this.configurationChanged();
    }

    protected void configurationChanged() {
        GlobalOptions newOptions = new GlobalOptions();
        String collabURL = this.getStringConfigProperty("com.smartbear.collaborator.URL");
        try {
            newOptions.setUrl(new URL(StringUtils.defaultIfEmpty((String)collabURL, (String)"http://collaborator:8080/")));
        }
        catch (MalformedURLException e) {
            this.getLog().error((Object)"Collaborator URL is Malformed", (Throwable)e);
        }
        String collabProxyHost = this.getStringConfigProperty("com.smartbear.collaborator.ProxyHost");
        newOptions.setServerProxyHost(collabProxyHost);
        String collabProxyPort = this.getStringConfigProperty("com.smartbear.collaborator.ProxyPort");
        newOptions.setServerProxyPort(collabProxyPort);
        String collabUser = this.getStringConfigProperty("com.smartbear.collaborator.Login");
        newOptions.setUser(StringUtils.defaultIfEmpty((String)collabUser, (String)"admin"));
        String collabPassword = this.getStringConfigProperty("com.smartbear.collaborator.Password");
        newOptions.setPassword(StringUtils.defaultIfEmpty((String)collabPassword, (String)""));
        this.options = newOptions;
    }

    @Override
    public ICollaboratorService getActualService() {
        return this;
    }

    @Override
    public void addChangelists(ConnectionInfo connection, ReviewInfo review, UserInfo actor, IScmClientConfiguration defaultConfig, Collection<? extends IScmChangelist> changelists) throws CollabClientException {
        if (review == null || review.getReviewId() == null) {
            throw new CollabClientException("Adding participants was failed because review is null ");
        }
        this.getLog().info((Object)("Adding changelists to review " + review.getReviewId() + " - " + changelists));
        CommandAddChangelist command = new CommandAddChangelist(defaultConfig);
        IChangelistRef[] refs = new IChangelistRef[changelists.size()];
        int i = 0;
        for (IScmChangelist iScmChangelist : changelists) {
            refs[i++] = new ChangelistRefByObject(iScmChangelist);
        }
        command.setPostCommit(Boolean.valueOf(true));
        command.setSkipIfExists(Boolean.valueOf(true));
        command.setIgnoreEmptyChangelists(Boolean.valueOf(true));
        command.setChangelists(refs);
        command.setReview(review.getReviewId().toString());
        command.validateAndExecute(actor, Collaborator.getClientInterface(), this.getConnectionOptions(connection), (IScmOptions)new ScmOptions(), (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void addParticipants(ConnectionInfo connection, ReviewInfo review, UserInfo actor, Collection<String> userLogins) throws CollabClientException {
        if (review == null || review.getReviewId() == null) {
            throw new CollabClientException("Adding participants was failed because review is null ");
        }
        this.getLog().info((Object)("Adding participants to review " + review.getReviewId() + " - " + userLogins));
        for (String user : userLogins) {
            CommandParticipantAssign command = new CommandParticipantAssign();
            command.setReview(review.getReviewId().toString());
            command.setRoleRef((IRoleRef)new RoleRefBySystemName("reviewer"));
            command.setParticipant((IUserRef)new UserRefByLogin(user));
            command.validateAndExecute(actor, Collaborator.getClientInterface(), this.getConnectionOptions(connection), (IScmOptions)new ScmOptions(), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Override
    public ReviewInfo findReview(ConnectionInfo connectionInfo, IWorkItem workItem) throws CollabClientException {
        try {
            return this.findReview(connectionInfo, workItem, this.findLinkToReview(workItem));
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ReviewInfo findOrCreateReview(UserInfo creator, IWorkItem workItem, Configuration configuration) throws CollabClientException {
        String string = workItem.getItemId().getUuidValue().intern();
        synchronized (string) {
            try {
                return this.doFindOrCreateReview(workItem, creator, configuration);
            }
            catch (TeamRepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private ReviewInfo findReview(ConnectionInfo connectionInfo, IWorkItem workItem, ILink reviewLink) throws CollabClientException {
        if (reviewLink == null) {
            throw new CollabClientException("No review found for workItem " + workItem.getId() + " - " + workItem.getItemId() + ". ReviewLink is null");
        }
        int reviewId = Integer.valueOf(reviewLink.getSourceRef().getExtraInfo());
        this.getLog().info((Object)("Found review " + reviewId + " for workItem " + workItem.getId() + " - " + workItem.getItemId()));
        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand(this.getConnectionOptions(connectionInfo));
        CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
        ReviewInfo reviewInfo = jsonApi.reviewApi().utilitiesApi().findReviewById(reviewId);
        return reviewInfo;
    }

    private List<Assignment> getReviewParticipants(ConnectionInfo connectionInfo, ReviewInfo reviewInfo) throws CollabClientException {
        if (reviewInfo == null) {
            return null;
        }
        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand(this.getConnectionOptions(connectionInfo));
        CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
        List assignmentList = jsonApi.reviewApi().participantsApi().getParticipants(reviewInfo.getReviewId().intValue());
        return assignmentList;
    }

    private ReviewInfo doFindOrCreateReview(IWorkItem workItem, UserInfo creator, Configuration configuration) throws TeamRepositoryException, CollabClientException {
        ILink link = this.findLinkToReview(workItem);
        ReviewInfo review = null;
        Phase phase = null;
        Log log = this.getLog();
        try {
            review = this.findReview(configuration.getConnectionInfo(), workItem, link);
            phase = JsonAPIHandler.fromReviewPhase((ReviewPhase)review.getReviewPhase());
        }
        catch (CollabClientException e) {
            log.info((Object)("Can't find review for workItem " + workItem.getId() + " - " + workItem.getItemId()), (Throwable)e);
        }
        if (review == null && link != null || configuration.createNewReviews() && review != null && phase.isFail()) {
            log.info((Object)("Severe review link for workItem " + workItem.getId() + " - " + workItem.getItemId() + " as review was deleted or terminated"));
            this.severLink(configuration.getConnectionInfo(), review, workItem, link, creator);
            review = null;
        }
        if (review == null) {
            log.info((Object)("Create new review for workItem " + workItem.getId() + " - " + workItem.getItemId()));
            review = this.createReviewWithLink(configuration.getConnectionInfo(), workItem, creator);
        } else if (phase.isTerminal()) {
            throw new CollabClientException("You cannot upload files to a finished review. If the review has been completed, you can reopen the review and try again.\nCheck with your administrator if you can reopen Completed or Cancelled reviews.\nIf the reivew has been Cancelled or Rejected you can configure the follow-up action to create new reviews by adding the <newReviewOnCancel value=\"true\"/> setting\n in order to create new reviews if the previous review was Cancelled or Rejected.");
        }
        return review;
    }

    private ReviewInfo createReviewWithLink(ConnectionInfo connection, IWorkItem workItem, UserInfo creator) throws CollabClientException, TeamRepositoryException {
        RtcWorkItem rtcWorkItem = this.extractScmWorkItem(workItem);
        ReviewInfo createdReview = this.createReview(connection, rtcWorkItem, creator);
        this.addLink(workItem, createdReview, this.getConnectionOptions(connection).getUrl());
        this.getLog().info((Object)("Created review " + createdReview.getReviewId() + " for workItem " + workItem.getId() + " - " + workItem.getItemId()));
        return createdReview;
    }

    private ILink findLinkToReview(IWorkItem workItem) throws TeamRepositoryException {
        ILinkQueryPage links = this.linkServiceLibrary.findLinksByTarget("com.smartbear.collaborator.rtc.process.relatedReview", (IReference)this.referenceFactory.createReferenceToItem((IItemHandle)workItem));
        return (ILink)SmartBearUtils.getFirstObject((Collection)links.getAllLinksFromHereOn());
    }

    private void severLink(ConnectionInfo connection, ReviewInfo review, IWorkItem workItem, ILink link, UserInfo login) throws TeamRepositoryException, CollabClientException {
        if (review != null) {
            IWorkItem copy = this.fetch(IWorkItem.class, (IItemHandle)workItem);
            copy = (IWorkItem)copy.getWorkingCopy();
            IApprovals approvals = copy.getApprovals();
            boolean dirty = false;
            for (Assignment assignment : this.getReviewParticipants(connection, review)) {
                IContributorHandle contributorHandle;
                IApproval approval;
                if (Role.REVIEWER != assignment.getRole() || (approval = this.findApproval(approvals, contributorHandle = this.contributorService.fetchContributorByUserId(assignment.getUser()))) == null) continue;
                approvals.remove(approval);
                dirty = true;
            }
            if (dirty) {
                this.workItemServer.saveWorkItem2(copy, null, null);
            }
            this.setWorkItemId(connection, review, "", login);
        }
        this.removeLink(link);
        this.getLog().debug((Object)("Removed link from workItem " + workItem.getId() + " - " + workItem.getItemId()));
    }

    private IApproval findApproval(IApprovals approvals, IContributorHandle contributor) {
        for (IApproval approval : approvals.getContents()) {
            if (!approval.getApprover().sameItemId((IItemHandle)contributor) || !WorkItemApprovals.REVIEW_TYPE.getIdentifier().equals(approval.getDescriptor().getTypeIdentifier())) continue;
            return approval;
        }
        return null;
    }

    @Override
    public RtcWorkItem extractScmWorkItem(IWorkItem workItem) throws TeamRepositoryException {
        String owner = this.fetch(IContributor.class, (IItemHandle)workItem.getOwner()).getUserId();
        HashSet<String> extraLogins = new HashSet<String>();
        for (IApproval a : workItem.getApprovals().getContents()) {
            IContributor c = this.fetch(IContributor.class, (IItemHandle)a.getApprover());
            extraLogins.add(c.getUserId());
        }
        String friendlyName = Integer.toString(workItem.getId());
        String shortDescription = workItem.getHTMLSummary().getPlainText();
        Location namedLocation = Location.namedLocation((IItem)workItem, (String)this.getPublicRepositoryURL());
        String workItemUrl = namedLocation.toAbsoluteUri().toString();
        RtcWorkItem result = new RtcWorkItem(owner, friendlyName, shortDescription, workItemUrl, extraLogins);
        this.getLog().debug((Object)("workItem metadata:\n" + result));
        return result;
    }

    @Override
    public ILinkCollection findWorkItemChangeSetLinks(IWorkItem workItem) throws TeamRepositoryException {
        IItemReference ref = this.referenceFactory.createReferenceToItem((IItemHandle)workItem);
        this.getLog().debug((Object)("looking up changeset links to " + ref));
        ILinkQueryPage linkQueryPage = this.linkServiceLibrary.findLinksByTarget(new String("com.ibm.team.filesystem.workitems.change_set"), (IReference)ref);
        ILinkCollection changeSetLinks = linkQueryPage.getAllLinksFromHereOn();
        return changeSetLinks;
    }

    @Override
    public <T extends IItem> T fetch(Class<T> clazz, IItemHandle handle) throws TeamRepositoryException {
        IItem item = this.repositoryItemService.fetchItem(handle, IRepositoryItemService.COMPLETE);
        return (T)((IItem)clazz.cast(item));
    }

    private ReviewInfo createReview(ConnectionInfo connection, RtcWorkItem rtcWorkItem, UserInfo login) throws CollabClientException {
        CommandReviewCreate command = new CommandReviewCreate();
        command.setCreator((IUserRef)new UserRefByLogin(rtcWorkItem.owner));
        command.setTitle(StringUtils.abbreviate((String)(rtcWorkItem.friendlyName + " - " + rtcWorkItem.shortDescription + " - " + rtcWorkItem.url), (int)255));
        command.setExternalTaskId(rtcWorkItem.friendlyName);
        command.validateAndExecute(login, Collaborator.getClientInterface(), this.getConnectionOptions(connection), (IScmOptions)new ScmOptions(), (IProgressMonitor)new NullProgressMonitor());
        return command.getCreatedReviewInfo();
    }

    private void addLink(IWorkItem workItem, ReviewInfo review, URL externalUrl) throws TeamRepositoryException, CollabClientException {
        String extraInfo = review.getReviewId().toString();
        String comment = "Review #" + review.getReviewId();
        IURIReference reviewRef = this.referenceFactory.createReferenceFromURI(RtcUtil.computeReviewURI((ReviewInfo)review, (URL)externalUrl), comment, extraInfo);
        IItemReference workItemRef = this.referenceFactory.createReferenceToItem((IItemHandle)workItem);
        ILink link = this.linkServiceLibrary.createLink("com.smartbear.collaborator.rtc.process.relatedReview", (IReference)reviewRef, (IReference)workItemRef);
        this.linkServiceLibrary.saveLink(link);
    }

    private void removeLink(ILink link) throws TeamRepositoryException {
        this.linkServiceLibrary.deleteLink(link);
    }

    private IGlobalOptions getConnectionOptions(ConnectionInfo connection) {
        ISettableGlobalOptions connectionOptions = GlobalOptions.copy((IGlobalOptions)this.options);
        if (StringUtils.isNotBlank((String)connection.getUrl())) {
            try {
                connectionOptions.setUrl(new URL(connection.getUrl()));
            }
            catch (MalformedURLException e) {
                this.getLog().warn((Object)("Invalid URL: " + connection.getUrl()), (Throwable)e);
            }
        }
        if (connection.getProxyHost() != null) {
            connectionOptions.setServerProxyHost(connection.getProxyHost());
        }
        if (connection.getProxyPort() != null) {
            connectionOptions.setServerProxyPort(connection.getProxyPort());
        }
        if (StringUtils.isNotBlank((String)connection.getUserID())) {
            connectionOptions.setUser(connection.getUserID());
        }
        if (connection.getUserPassword() != null) {
            connectionOptions.setPassword(connection.getUserPassword());
        }
        return connectionOptions;
    }

    @Override
    public UserInfo jsonLogin(ConnectionInfo connection) throws CollabClientException {
        IGlobalOptions options = this.getConnectionOptions(connection);
        return LoginUtils.jsonLogin((IGlobalOptions)options, (ICollabClientInterface)new NullClient());
    }

    @Override
    public RtcConfig newRtcConfig() {
        return new RtcConfig(this, this.scmService, this.serverSideVersionedContentService, this.getPublicRepositoryURL());
    }

    @Override
    public List<RtcChangeSet> wrapLinkedChangeSets(RtcConfig rtcConfig, ILinkCollection changeSetLinks) throws TeamRepositoryException {
        ArrayList<RtcChangeSet> changeSets = new ArrayList<RtcChangeSet>();
        for (ILink link : changeSetLinks) {
            if (!link.getSourceRef().isItemReference()) {
                this.getLog().debug((Object)("skipping non item reference: " + link.getLinkTypeId()));
                continue;
            }
            IReference sourceRef = link.getSourceRef();
            RtcChangeSet scmChangeSet = this.wrapReferencedChangeSet(rtcConfig, sourceRef);
            if (scmChangeSet == null) continue;
            changeSets.add(scmChangeSet);
        }
        return changeSets;
    }

    @Override
    public RtcChangeSet wrapReferencedChangeSet(RtcConfig config, IReference changeSetRef) throws TeamRepositoryException {
        IItemHandle itemHandle = ((IItemReference)changeSetRef).getReferencedItem();
        if (!(itemHandle instanceof IChangeSetHandle)) {
            this.getLog().debug((Object)("skipping non changeset link: " + itemHandle.getItemType().getName()));
            return null;
        }
        IChangeSetHandle changeSetHandle = (IChangeSetHandle)itemHandle;
        IWorkspaceHandle workspaceHandle = this.extractWorkspaceHandle(changeSetRef);
        IChangeSet changeSet = (IChangeSet)this.repositoryItemService.fetchItem((IItemHandle)changeSetHandle, IRepositoryItemService.COMPLETE);
        IContributorHandle author = changeSet.getAuthor();
        IContributor contributor = (IContributor)this.repositoryItemService.fetchItem((IItemHandle)author, IRepositoryItemService.COMPLETE);
        IComponent component = (IComponent)this.repositoryItemService.fetchItem((IItemHandle)changeSet.getComponent(), IRepositoryItemService.COMPLETE);
        config.setComponent(component);
        RtcChangeSet scmChangeSet = new RtcChangeSet(config, changeSet, component, workspaceHandle, contributor);
        return scmChangeSet;
    }

    private IWorkspaceHandle extractWorkspaceHandle(IReference sourceRef) {
        String extraInfo = sourceRef.getExtraInfo();
        if (StringUtils.isEmpty((String)extraInfo) || !extraInfo.startsWith(CHANGE_SET_WORKSPACE_HINT_PREFIX)) {
            return null;
        }
        String workspaceItemIdString = extraInfo.substring(CHANGE_SET_WORKSPACE_HINT_PREFIX_LENGTH);
        if (StringUtils.isEmpty((String)workspaceItemIdString)) {
            return null;
        }
        UUID workspaceItemId = UUID.valueOf((String)workspaceItemIdString);
        this.getLog().debug((Object)("workspaceItemId=" + workspaceItemIdString));
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceItemId, null);
        return workspaceHandle;
    }

    @Override
    public void setWorkItemId(ConnectionInfo connection, ReviewInfo review, String workItemId, UserInfo actor) throws CollabClientException {
        if (review == null || review.getReviewId() == null) {
            throw new CollabClientException("Setting workItemId was failed because review is null ");
        }
        CommandReviewEdit command = new CommandReviewEdit();
        command.setReview(review.getReviewId().toString());
        command.setExternalTaskId(workItemId);
        command.validateAndExecute(actor, Collaborator.getClientInterface(), this.getConnectionOptions(connection), (IScmOptions)new ScmOptions(), (IProgressMonitor)new NullProgressMonitor());
    }
}

