/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc.process;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.smartbear.collaborator.rtc.process.ConnectionInfo;
import com.smartbear.scm.impl.rtc.IFollowupConfiguration;
import com.smartbear.scm.impl.rtc.Status;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;

public class Configuration
extends BasicEObjectImpl
implements IFollowupConfiguration {
    private static final String VALUE_ATTR = "value";
    private static final Map<String, ConfigurationType> elementTypes = new HashMap<String, ConfigurationType>();
    private Set<String> types = new HashSet<String>();
    private Set<String> states = new HashSet<String>();
    private Set<Status> statuses = new HashSet<Status>();
    private ConnectionInfo connectionInfo = new ConnectionInfo();
    private boolean shouldUpdateReviewers = true;
    private boolean newReviewOnCancel;
    private Integer retries;
    private Integer retryDelayMs;

    public static Configuration create(IProcessConfigurationElement participantConfig) {
        IProcessConfigurationElement[] children;
        Configuration config = new Configuration();
        for (IProcessConfigurationElement confEl : children = participantConfig.getChildren()) {
            ConfigurationType type = elementTypes.get(confEl.getName());
            if (type == null) continue;
            type.process(config, confEl);
        }
        return config;
    }

    private Configuration() {
    }

    public Set<String> getTypes() {
        return new HashSet<String>(this.types);
    }

    public Set<String> getStates() {
        return new HashSet<String>(this.states);
    }

    public Set<Status> getStatuses() {
        return new HashSet<Status>(this.statuses);
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public boolean updateReviewers() {
        return this.shouldUpdateReviewers;
    }

    public boolean createNewReviews() {
        return this.newReviewOnCancel;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public Integer getRetryDelayMs() {
        return this.retryDelayMs;
    }

    static {
        for (ConfigurationType type : ConfigurationType.values()) {
            elementTypes.put(type.element, type);
        }
    }

    private static enum ConfigurationType {
        TYPE("type"){

            @Override
            void process(Configuration config, IProcessConfigurationElement element) {
                config.types.add(this.getValue(element));
            }
        }
        ,
        STATE("StateChangedTo"){

            @Override
            void process(Configuration config, IProcessConfigurationElement element) {
                config.states.add(this.getValue(element));
            }
        }
        ,
        ON_STATUS("OnStatus"){

            @Override
            void process(Configuration config, IProcessConfigurationElement element) {
                config.statuses.add(new Status(element.getAttribute("type"), element.getAttribute("state")));
            }
        }
        ,
        URL("CollaboratorURL"){

            @Override
            void process(Configuration config, IProcessConfigurationElement element) {
                config.getConnectionInfo().setUrl(this.getValue(element));
            }
        }
        ,
        PROXY_HOST("CollaboratorProxyHost"){

            @Override
            void process(Configuration config, IProcessConfigurationElement element) {
                config.getConnectionInfo().setProxyHost(this.getValue(element));
            }
        }
        ,
        PROXY_PORT("CollaboratorProxyPort"){

            @Override
            void process(Configuration config, IProcessConfigurationElement element) {
                config.getConnectionInfo().setProxyPort(this.getValue(element));
            }
        }
        ,
        USER_ID("CollaboratorUserID"){

            @Override
            void process(Configuration config, IProcessConfigurationElement element) {
                config.getConnectionInfo().setUserID(this.getValue(element));
            }
        }
        ,
        USER_PASSWORD("CollaboratorUserPassword"){

            @Override
            void process(Configuration config, IProcessConfigurationElement element) {
                config.getConnectionInfo().setUserPassword(this.getValue(element));
            }
        }
        ,
        UPDATE_REVIEWERS("updateReviewers"){

            @Override
            void process(Configuration config, IProcessConfigurationElement element) {
                config.shouldUpdateReviewers = Boolean.parseBoolean(this.getValue(element));
            }
        }
        ,
        NEW_REVIEW_ON_CANCEL("newReviewOnCancel"){

            @Override
            void process(Configuration config, IProcessConfigurationElement element) {
                config.newReviewOnCancel = Boolean.parseBoolean(this.getValue(element));
            }
        }
        ,
        RETRIES("retries"){

            @Override
            void process(Configuration config, IProcessConfigurationElement element) {
                config.retries = this.getIntValue(element);
            }
        }
        ,
        RETRY_DELAY("retryDelayMs"){

            @Override
            void process(Configuration config, IProcessConfigurationElement element) {
                config.retryDelayMs = this.getIntValue(element);
            }
        };

        private final String element;

        private ConfigurationType(String element) {
            this.element = element;
        }

        abstract void process(Configuration var1, IProcessConfigurationElement var2);

        protected String getValue(IProcessConfigurationElement element) {
            return element.getAttribute(Configuration.VALUE_ATTR);
        }

        protected Integer getIntValue(IProcessConfigurationElement element) {
            try {
                return Integer.parseInt(this.getValue(element));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }
}

