/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc.process;

import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.service.IPostOutermostTransactionTask;
import com.ibm.team.repository.service.async.AbstractPostOutermostTransactionTask;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.json.interfaces.review.request.CustomField;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewInfo;
import com.smartbear.collaborator.json.interfaces.user.response.UserInfo;
import com.smartbear.collaborator.rtc.process.Configuration;
import com.smartbear.collaborator.rtc.process.ConnectionInfo;
import com.smartbear.collaborator.rtc.process.ICollaboratorService;
import com.smartbear.collaborator.rtc.process.RtcChangeSet;
import com.smartbear.collaborator.rtc.process.RtcConfig;
import com.smartbear.collaborator.rtc.process.RtcWorkItem;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.util.SmartBearUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.eclipse.emf.ecore.EObject;

public class CreateOrUpdateReviewTask
extends AbstractPostOutermostTransactionTask
implements IPostOutermostTransactionTask {
    public static final String TASK_ID = "com.smartbear.collaborator.rtc.process.createOrUpdateReviewTask";
    public static final String INTERNAL_CUSTOM_FIELD_TASKID = "ExternalTaskId";

    public String getTaskId() {
        return TASK_ID;
    }

    public void transactionFailed(EObject[] data) {
        this.getLog().debug((Object)"transaction failed, doing nothing");
    }

    public void transactionSucceeded(EObject[] data, boolean wasReadOnly) {
        Log log = this.getLog();
        log.debug((Object)"transaction succeeded, uploading changes");
        IWorkItem workItem = (IWorkItem)data[0];
        Configuration configuration = (Configuration)data[1];
        try {
            this.uploadFilesInChangeSets(workItem, configuration);
        }
        catch (Exception t) {
            log.error((Object)"unexpected throwable", (Throwable)t);
            SmartBearUtils.rethrowIfUnchecked((Throwable)t);
            throw new RuntimeException(t.getMessage(), t);
        }
        log.debug((Object)"done uploading changes");
    }

    private void uploadFilesInChangeSets(IWorkItem workItem, Configuration configuration) throws TeamRepositoryException, IOException, CollabClientException {
        Log log = this.getLog();
        ICollaboratorService collab = ((ICollaboratorService)this.getService(ICollaboratorService.class)).getActualService();
        ILinkCollection changeSetLinks = collab.findWorkItemChangeSetLinks(workItem);
        RtcConfig rtcConfig = collab.newRtcConfig();
        List<RtcChangeSet> changeSets = collab.wrapLinkedChangeSets(rtcConfig, changeSetLinks);
        log.debug((Object)"changesets acquired");
        if (changeSets.isEmpty()) {
            log.debug((Object)"No changesets were attached to the Work Item, no review has been created");
        }
        this.doUploadChangeSets(rtcConfig, changeSets, collab, workItem, configuration);
    }

    private void doUploadChangeSets(RtcConfig rtcConfig, List<RtcChangeSet> changeSets, ICollaboratorService collab, IWorkItem workItem, Configuration configuration) throws TeamRepositoryException, IOException, CollabClientException {
        ConnectionInfo connection = configuration.getConnectionInfo();
        UserInfo login = collab.jsonLogin(connection);
        ReviewInfo review = collab.findOrCreateReview(login, workItem, configuration);
        workItem = collab.fetch(IWorkItem.class, (IItemHandle)workItem);
        String externalTaskId = this.getExternalTaskId(review);
        if (StringUtils.isBlank((String)externalTaskId)) {
            collab.setWorkItemId(connection, review, String.valueOf(workItem.getId()), login);
        } else {
            this.getLog().debug((Object)("Review with ID " + review.getReviewId() + " already has an external task ID: " + externalTaskId));
        }
        RtcWorkItem rtcWorkItem = collab.extractScmWorkItem(workItem);
        if (!changeSets.isEmpty()) {
            collab.addChangelists(connection, review, login, (IScmClientConfiguration)rtcConfig, changeSets);
        }
        collab.addParticipants(connection, review, login, rtcWorkItem.extraLogins);
    }

    private String getExternalTaskId(ReviewInfo review) {
        String externalTaskId = null;
        List internalCustomFields = review.getInternalCustomFields();
        if (internalCustomFields != null) {
            for (CustomField customField : internalCustomFields) {
                if (!INTERNAL_CUSTOM_FIELD_TASKID.equals(customField.getName())) continue;
                externalTaskId = (String)SmartBearUtils.getFirstObject((Collection)customField.getValue());
            }
        }
        return externalTaskId;
    }
}

