/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc.process;

import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.ISynchronizationTimes;
import com.ibm.team.scm.common.internal.dto.ServiceConfigurationProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;

public class PathResolver {
    private static Log LOG = LogFactory.getLog((String)"com.smartbear.collaborator.rtc.process");
    private final IWorkspaceHandle workspace;
    private final IComponent component;
    private final IScmService scmService;

    public PathResolver(IWorkspaceHandle workspace, IComponent component, IScmService scmService) {
        this.workspace = workspace;
        this.component = component;
        this.scmService = scmService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolve(IVersionableHandle handle) throws TeamRepositoryException {
        Object path;
        IVersionable item = null;
        try {
            Method fetchState = IScmService.class.getMethod("fetchState", IVersionableHandle.class, String[].class, IRepositoryProgressMonitorHandle.class);
            item = (IVersionable)fetchState.invoke((Object)this.scmService, handle, null, null);
        }
        catch (NoSuchMethodException fetchState) {
        }
        catch (IllegalAccessException fetchState) {
        }
        catch (InvocationTargetException fetchState) {
        }
        finally {
            if (item == null) {
                item = this.scmService.fetchState(handle, null, null);
            }
        }
        LOG.debug((Object)("calculating path for " + item));
        if (this.workspace == null) {
            path = "/unresolved-path/" + item.getItemId().getUuidValue() + "/" + item.getName();
            LOG.debug((Object)("no workspace available, constructing artificial path: " + (String)path));
            return path;
        }
        path = new StringBuilder();
        ServiceConfigurationProvider scp = ServiceConfigurationProvider.FACTORY.create(this.workspace, (IComponentHandle)this.component);
        IVersionableHandle[] handles = new IVersionableHandle[]{item.getParent()};
        IAncestorReport[] ancestorReports = null;
        try {
            Method configurationLocateAncestors = IScmService.class.getMethod("configurationLocateAncestors", ServiceConfigurationProvider.class, IVersionableHandle[].class, ISynchronizationTimes[].class, IRepositoryProgressMonitorHandle.class);
            ancestorReports = (IAncestorReport[])configurationLocateAncestors.invoke((Object)this.scmService, scp, handles, null, null);
        }
        catch (NoSuchMethodException configurationLocateAncestors) {
        }
        catch (IllegalAccessException configurationLocateAncestors) {
        }
        catch (InvocationTargetException configurationLocateAncestors) {
        }
        finally {
            if (ancestorReports == null) {
                ancestorReports = this.scmService.configurationLocateAncestors(scp, handles, null, null);
            }
        }
        List nameItemPairs = ancestorReports[0].getNameItemPairs();
        for (INameItemPair nameItemPair : nameItemPairs) {
            String versionableName = nameItemPair.getName();
            if (versionableName == null) continue;
            ((StringBuilder)path).append('/').append(versionableName);
        }
        ((StringBuilder)path).append('/').append(item.getName());
        String resolved = ((StringBuilder)path).toString();
        LOG.debug((Object)("calculated path: " + resolved));
        return resolved;
    }
}

