/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc.process;

import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.rtc.IRtcClientConfiguration;
import com.smartbear.collaborator.rtc.RtcVersionFactory;
import com.smartbear.collaborator.rtc.process.PathResolver;
import com.smartbear.collaborator.rtc.process.RtcConfig;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.IScmLocalCheckout;
import com.smartbear.scm.IScmVersion;
import com.smartbear.scm.ScmAccessControlException;
import com.smartbear.scm.ScmCommitInfoSimple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class RtcChangeSet
implements IScmChangelist {
    private RtcConfig config;
    private IChangeSet changeSet = null;
    private IContributor contributor;
    private IWorkspaceHandle workspaceHandle = null;
    private IComponent component = null;
    private ScmCommitInfoSimple commitInfo;
    private List<IScmVersion> versions;

    public IChangeSetHandle getChangeSetHandle() {
        return this.changeSet;
    }

    public IWorkspaceHandle getWorkspaceHandle() {
        return this.workspaceHandle;
    }

    public RtcChangeSet(RtcConfig config, IChangeSet changeSetHandle, IComponent component, IWorkspaceHandle workspaceHandle, IContributor contributor) {
        this.config = config;
        this.changeSet = changeSetHandle;
        this.component = component;
        this.contributor = contributor;
        this.workspaceHandle = workspaceHandle;
    }

    public void loadVersions() throws TeamRepositoryException, IOException, ScmCommunicationException {
        if (this.versions != null) {
            return;
        }
        ArrayList<IScmVersion> loading = new ArrayList<IScmVersion>();
        List allChanges = this.changeSet.changes();
        ArrayList<IChange> fileChanges = new ArrayList<IChange>();
        for (IChange change : allChanges) {
            if (!(change.item() instanceof IFileItemHandle)) continue;
            fileChanges.add(change);
        }
        PathResolver resolver = new PathResolver(this.workspaceHandle, this.component, this.config.scmService);
        for (IChange change : fileChanges) {
            String path = this.resolvePath(change.afterState(), resolver);
            String previousPath = this.resolvePath(change.beforeState(), resolver);
            loading.addAll(RtcVersionFactory.loadVersions((IRtcClientConfiguration)this.config, (IScmChangelist)this, (IChange)change, (String)path, (String)previousPath));
        }
        this.versions = loading;
    }

    private String resolvePath(IVersionableHandle handle, PathResolver resolver) throws ScmCommunicationException {
        try {
            return handle == null ? null : resolver.resolve(handle);
        }
        catch (TeamRepositoryException e) {
            throw new ScmCommunicationException((Exception)((Object)e));
        }
    }

    public void checkAccessPermission(String user, IProgressMonitor monitor) throws ScmCommunicationException, ScmAccessControlException {
    }

    public IScmClientConfiguration getClientConfiguration() {
        return this.config;
    }

    public ScmCommitInfoSimple getCommitInfo() {
        if (this.commitInfo == null) {
            this.commitInfo = new ScmCommitInfoSimple();
            this.commitInfo.setAuthor(this.contributor.getUserId());
            this.commitInfo.setComment(StringUtils.defaultIfEmpty((String)this.changeSet.getComment(), (String)"<No Comment>"));
            this.commitInfo.setDate(this.changeSet.getLastChangeDate());
        }
        return new ScmCommitInfoSimple(this.commitInfo);
    }

    public String getId() {
        return this.changeSet.getItemId().getUuidValue();
    }

    public List<IScmLocalCheckout> getLocalCheckouts(IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public List<IScmVersion> getVersions(IProgressMonitor monitor) throws ScmCommunicationException {
        try {
            this.loadVersions();
        }
        catch (TeamRepositoryException e) {
            throw new ScmCommunicationException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ScmCommunicationException((Exception)e);
        }
        return this.versions;
    }

    public boolean isAtomic() {
        return true;
    }

    public boolean isPending() {
        return !this.changeSet.isImmutable();
    }

    public int compareTo(Object o) {
        return this.getCommitInfo().getDate().compareTo(((IScmChangelist)o).getCommitInfo().getDate());
    }

    public String toString() {
        return "RtcChangeSet commitInfo=" + this.getCommitInfo().toString();
    }

    public List<String> getChangelistLog() {
        return Collections.EMPTY_LIST;
    }
}

