/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc.process;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.service.IServerSideVersionedContentService;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.rtc.IRtcClientConfiguration;
import com.smartbear.collaborator.rtc.process.ICollaboratorService;
import com.smartbear.collections.Tuple;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.IScmConnectionParameters;
import com.smartbear.scm.IScmLocalCheckout;
import com.smartbear.scm.IScmSystem;
import com.smartbear.scm.IScmVersion;
import com.smartbear.scm.ScmConfigurationException;
import com.smartbear.scm.impl.common.ScmConnectionParameters;
import com.smartbear.scm.impl.rtc.RtcSystem;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;

public class RtcConfig
implements IRtcClientConfiguration {
    IScmService scmService;
    IServerSideVersionedContentService ssvcs;
    String publicRepoURL;
    ICollaboratorService cocoService;
    IComponent component;

    public RtcConfig(ICollaboratorService cocoService, IScmService scmService, IServerSideVersionedContentService ssvcs, String publicRepoURL) {
        this.cocoService = cocoService;
        this.scmService = scmService;
        this.ssvcs = ssvcs;
        this.publicRepoURL = publicRepoURL;
    }

    public void setComponent(IComponent component) {
        this.component = component;
    }

    public IScmChangelist getChangelist(String id, IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public String getDisplayableConfiguration() {
        String config = "Team Repository: " + this.publicRepoURL;
        if (this.component != null) {
            config = config + " - Component: " + this.component.getName();
        }
        return config;
    }

    public IScmChangelist[] getLocalChangelists(IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public IScmLocalCheckout getLocalCheckout(File path, IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public List<IScmLocalCheckout> getModifiedFiles(File directory, IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public IScmSystem getScmSystem() {
        return RtcSystem.INSTANCE;
    }

    public IScmConnectionParameters getServerConfiguration(IScmLocalCheckout checkout, IScmVersion version, IScmChangelist change) throws ScmConfigurationException, ScmCommunicationException {
        if (this.component != null) {
            return new ScmConnectionParameters(this.publicRepoURL, this.component.getName(), this.component.getItemId().getUuidValue());
        }
        return new ScmConnectionParameters(this.publicRepoURL);
    }

    public String getUserName() {
        return null;
    }

    public IScmVersion getVersion(Tuple<String> versionSpec, IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public void logStatus(IProgressMonitor monitor) throws ScmCommunicationException {
        Log log = LogFactory.getLog((String)"com.smartbear.collaborator.rtc.process");
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug((Object)("public repo: " + this.publicRepoURL));
        log.debug((Object)("IScmService: " + this.scmService));
        log.debug((Object)("Content Service: " + this.ssvcs));
    }

    public IFileItem fetchFileItem(IVersionableHandle handle, IProgressMonitor monitor) throws ScmCommunicationException {
        try {
            return (IFileItem)this.fetchVersionable(handle, monitor);
        }
        catch (TeamRepositoryException e) {
            throw new ScmCommunicationException((Exception)((Object)e));
        }
    }

    public byte[] fetchContent(IVersionableHandle state, IProgressMonitor monitor) throws ScmCommunicationException {
        if (!(state instanceof IFileItemHandle)) {
            throw new IllegalArgumentException("content only makes sense for file items");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IFileItem fileItem = this.fetchFileItem(state, monitor);
            this.loadContent(fileItem, baos);
            return baos.toByteArray();
        }
        catch (TeamRepositoryException e) {
            throw new ScmCommunicationException((Exception)((Object)e));
        }
    }

    public IContributor fetchContributor(IContributorHandle handle, IProgressMonitor monitor) throws ScmCommunicationException {
        try {
            return this.cocoService.fetch(IContributor.class, (IItemHandle)handle);
        }
        catch (TeamRepositoryException e) {
            throw new ScmCommunicationException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IVersionable fetchVersionable(IVersionableHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        IFileItem result = null;
        try {
            Method fetchState = IScmService.class.getMethod("fetchState", IVersionableHandle.class, String[].class, IRepositoryProgressMonitorHandle.class);
            result = (IFileItem)fetchState.invoke((Object)this.scmService, handle, IScmService.COMPLETE, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        finally {
            if (result == null) {
                result = (IFileItem)this.scmService.fetchState(handle, IScmService.COMPLETE, null);
            }
        }
        return result;
    }

    private void loadContent(IFileItem fileItem, OutputStream target) throws TeamRepositoryException {
        this.ssvcs.fetchContent((IVersionableHandle)fileItem, fileItem.getContent().getHash(), target);
    }

    public List getHistoryForVersionable(IVersionableHandle version, int limit) throws Exception {
        throw new UnsupportedOperationException("Mehod getHistoryForVersionable(IVersionableHandle version, int limit) is not implemented in class " + this.getClass().getName());
    }

    public IChangeSet fetchChangeSet(IChangeSetHandle changeSetHandle) throws TeamRepositoryException {
        throw new UnsupportedOperationException("Mehod fetchChangeSet(IChangeSetHandle changeSetHandle) is not implemented in class " + this.getClass().getName());
    }
}

