/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.rtc.process;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.runtime.IOperationParticipant;
import com.ibm.team.process.common.advice.runtime.IParticipantInfoCollector;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.service.AbstractService;
import com.ibm.team.repository.service.ITransactionService;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.smartbear.collaborator.rtc.process.Configuration;
import com.smartbear.collaborator.rtc.process.ConnectionInfo;
import com.smartbear.scm.impl.rtc.CheckAccessUtils;
import com.smartbear.scm.impl.rtc.IFollowupConfiguration;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;

public class UploadToCollabProcessParticipant
extends AbstractService
implements IOperationParticipant {
    public void run(AdvisableOperation operation, IProcessConfigurationElement participantConfig, IParticipantInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        ITransactionService transactionService;
        this.getLog().debug((Object)"UploadToCollabProcessParticpant running");
        Object data = operation.getOperationData();
        if (!(data instanceof ISaveParameter)) {
            this.getLog().debug((Object)"UploadToCollabProcessParticpant quitting early because operation data is not an ISaveParameter");
            return;
        }
        this.getLog().debug((Object)"UploadToCollabProcessParticpant checking work item state");
        ISaveParameter saveParameter = (ISaveParameter)data;
        IItem fullState = saveParameter.getNewState().getFullState();
        if (!(fullState instanceof IWorkItem)) {
            this.getLog().debug((Object)("UploadToCollabProcessParticpant quitting early because save parameter is not an IWorkItem, is a: " + fullState.getClass()));
            return;
        }
        IWorkItem currentWorkItem = (IWorkItem)fullState;
        IWorkItemCommon workItemCommon = (IWorkItemCommon)this.getService(IWorkItemCommon.class);
        IWorkflowInfo workFlowInfo = workItemCommon.findWorkflowInfo(currentWorkItem, monitor);
        String currentState = workFlowInfo.getStateName(currentWorkItem.getState2());
        this.getLog().debug((Object)("WorkItem current state: " + currentState));
        boolean workItemStateChanged = false;
        if (!saveParameter.isCreation()) {
            IWorkItem oldWorkItem = (IWorkItem)saveParameter.getOldState().getFullState();
            String oldState = workFlowInfo.getStateName(oldWorkItem.getState2());
            this.getLog().debug((Object)("WorkItem oldState state: " + oldState));
            workItemStateChanged = !currentState.equals(oldState);
        }
        boolean approvalAdditions = this.hasApprovalAddition(saveParameter);
        if (!workItemStateChanged && !approvalAdditions) {
            this.getLog().debug((Object)"UploadToCollabProcessParticpant quitting early because work item state is not changed");
            return;
        }
        this.getLog().debug((Object)"UploadToCollabProcessParticpant processing configuration");
        Configuration config = Configuration.create(participantConfig);
        ConnectionInfo connection = config.getConnectionInfo();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("UploadToCollabProcessParticipant allowing types: " + config.getTypes()));
            this.getLog().debug((Object)("UploadToCollabProcessParticipant allowing states: " + config.getStates()));
            this.getLog().debug((Object)("UploadToCollabProcessParticipant allowing statuses: " + config.getStatuses()));
        }
        String type = currentWorkItem.getWorkItemType();
        List workItemTypes = workItemCommon.findWorkItemTypes(currentWorkItem.getProjectArea(), (IProgressMonitor)new NullProgressMonitor());
        for (IWorkItemType workItemType : workItemTypes) {
            if (!workItemType.getIdentifier().equals(type)) continue;
            type = workItemType.getDisplayName();
            break;
        }
        if (workItemStateChanged && CheckAccessUtils.checkAllowedStatus((IFollowupConfiguration)config, (String)type, (String)currentState)) {
            this.getLog().debug((Object)"UploadToCollabProcessParticpant starting upload task");
            transactionService = (ITransactionService)this.getService(ITransactionService.class);
            transactionService.executeTaskAfterCurrentOutermostTransaction("com.smartbear.collaborator.rtc.process", "com.smartbear.collaborator.rtc.process.createOrUpdateReviewTask", new EObject[]{(EObject)currentWorkItem, config});
        } else if (approvalAdditions && config.updateReviewers()) {
            this.getLog().debug((Object)"UploadToCollabProcessParticpant starting add approvals to review task");
            transactionService = (ITransactionService)this.getService(ITransactionService.class);
            transactionService.executeTaskAfterCurrentOutermostTransaction("com.smartbear.collaborator.rtc.process", "com.smartbear.collaborator.rtc.process.addApprovalsToLinkedReviewTask", new EObject[]{(EObject)currentWorkItem, connection});
        }
        this.getLog().debug((Object)"UploadToCollabProcessParticpant done running");
    }

    private boolean hasApprovalAddition(ISaveParameter saveParameter) {
        IWorkItem newState = (IWorkItem)saveParameter.getNewState();
        IWorkItem oldState = (IWorkItem)saveParameter.getOldState();
        List oldApprovals = oldState == null ? Collections.emptyList() : oldState.getApprovals().getContents();
        List newApprovals = newState == null ? Collections.emptyList() : newState.getApprovals().getContents();
        return !this.containsAll(oldApprovals, newApprovals);
    }

    private boolean containsAll(List<IApproval> container, List<IApproval> contained) {
        if (container.size() < contained.size()) {
            return false;
        }
        for (IApproval toCheck : contained) {
            boolean found = false;
            for (IApproval fromContainer : container) {
                found |= this.equals(toCheck, fromContainer);
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean equals(IApproval app1, IApproval app2) {
        if (app1 == null || app2 == null) {
            return false;
        }
        return app1.getApprover().getItemId().equals((Object)app2.getApprover().getItemId()) && app1.getDescriptor().getTypeIdentifier().equals(app2.getDescriptor().getTypeIdentifier()) && app1.getDescriptor().getName().equals(app2.getDescriptor().getName());
    }
}

