/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.git;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.io.AutoCRLFInputStream;
import org.eclipse.osgi.util.NLS;

public class BlobStorage
implements IStorage {
    protected final Repository db;
    private final String path;
    private final ObjectId blobId;

    BlobStorage(Repository repository, String fileName, ObjectId blob) {
        this.db = repository;
        this.path = fileName;
        this.blobId = blob;
    }

    public InputStream getContents() throws CoreException {
        try {
            return this.open();
        }
        catch (IOException e) {
            return null;
        }
    }

    private InputStream open() throws IOException, CoreException, IncorrectObjectTypeException {
        if (this.blobId == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            WorkingTreeOptions workingTreeOptions = (WorkingTreeOptions)this.db.getConfig().get(WorkingTreeOptions.KEY);
            switch (workingTreeOptions.getAutoCRLF()) {
                case INPUT: 
                case FALSE: {
                    return this.db.open((AnyObjectId)this.blobId, 3).openStream();
                }
                case TRUE: {
                    return new AutoCRLFInputStream((InputStream)this.db.open((AnyObjectId)this.blobId, 3).openStream(), true);
                }
            }
            return null;
        }
        catch (MissingObjectException notFound) {
            throw new CoreException(Activator.error((String)NLS.bind((String)"CoreText.BlobStorage_blobNotFound", (Object)this.blobId.name(), (Object)this.path), null));
        }
    }

    public IPath getFullPath() {
        return Path.fromPortableString((String)this.path);
    }

    public String getName() {
        int last = this.path.lastIndexOf(47);
        if (last == this.path.length() - 1) {
            return this.path;
        }
        return last >= 0 ? this.path.substring(last + 1) : this.path;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

