/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.git;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.core.synchronize.GitCommitsModelDirectionException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitCollabCommitsModelCache {
    public static final int ADDITION = 1;
    public static final int DELETION = 2;
    public static final int CHANGE = 3;
    private static final int CHANGE_TYPE_MASK = 3;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    static final AbbreviatedObjectId ZERO_ID = AbbreviatedObjectId.fromObjectId((AnyObjectId)ObjectId.zeroId());

    public static List<Commit> build(Repository repo, ObjectId srcId, ObjectId dstId, TreeFilter pathFilter) throws IOException {
        RevCommit revCommit;
        if (dstId != null && dstId.equals((AnyObjectId)srcId)) {
            return new ArrayList<Commit>(0);
        }
        RevWalk rw = new RevWalk(repo);
        RevFlag localFlag = rw.newFlag("local");
        RevFlag remoteFlag = rw.newFlag("remote");
        RevFlagSet allFlags = new RevFlagSet();
        allFlags.add(localFlag);
        allFlags.add(remoteFlag);
        rw.carry((Collection)allFlags);
        RevCommit srcCommit = rw.parseCommit((AnyObjectId)srcId);
        srcCommit.add(localFlag);
        rw.markStart(srcCommit);
        srcCommit = null;
        RevCommit dstCommit = null;
        if (dstId != null) {
            dstCommit = rw.parseCommit((AnyObjectId)dstId);
            dstCommit.add(remoteFlag);
            rw.markStart(dstCommit);
            dstCommit = null;
        }
        if (pathFilter != null) {
            rw.setTreeFilter(pathFilter);
        }
        ArrayList<Commit> result = new ArrayList<Commit>();
        Iterator iterator = rw.iterator();
        while (iterator.hasNext() && !(revCommit = (RevCommit)iterator.next()).hasAll(allFlags)) {
            Commit commit = new Commit();
            commit.shortMessage = revCommit.getShortMessage();
            commit.commitId = AbbreviatedObjectId.fromObjectId((AnyObjectId)revCommit);
            commit.authorName = revCommit.getAuthorIdent().getName();
            commit.committerName = revCommit.getCommitterIdent().getName();
            commit.commitDate = revCommit.getAuthorIdent().getWhen();
            RevCommit parentCommit = GitCollabCommitsModelCache.getParentCommit(revCommit);
            if (revCommit.has(localFlag)) {
                commit.direction = 8;
            } else if (revCommit.has(remoteFlag)) {
                commit.direction = 4;
            } else {
                throw new GitCommitsModelDirectionException();
            }
            commit.children = GitCollabCommitsModelCache.getChangedObjects(repo, revCommit, parentCommit, pathFilter, commit.direction);
            if (commit.children == null) continue;
            result.add(commit);
        }
        rw.dispose();
        return result;
    }

    private static RevCommit getParentCommit(RevCommit commit) {
        if (commit.getParents().length > 0) {
            return commit.getParents()[0];
        }
        return null;
    }

    private static Map<String, Change> getChangedObjects(Repository repo, RevCommit commit, RevCommit parentCommit, TreeFilter pathFilter, int direction) throws IOException {
        TreeWalk tw = new TreeWalk(repo);
        int commitIndex = GitCollabCommitsModelCache.addTree(tw, commit);
        int parentCommitIndex = GitCollabCommitsModelCache.addTree(tw, parentCommit);
        tw.setRecursive(true);
        if (pathFilter == null) {
            tw.setFilter(TreeFilter.ANY_DIFF);
        } else {
            tw.setFilter(AndTreeFilter.create((TreeFilter)TreeFilter.ANY_DIFF, (TreeFilter)pathFilter));
        }
        HashMap<String, Change> result = new HashMap<String, Change>();
        AbbreviatedObjectId commitId = GitCollabCommitsModelCache.getAbbreviatedObjectId(commit);
        AbbreviatedObjectId parentCommitId = GitCollabCommitsModelCache.getAbbreviatedObjectId(parentCommit);
        MutableObjectId idBuf = new MutableObjectId();
        while (tw.next()) {
            Change change = new Change();
            change.commitId = commitId;
            change.remoteCommitId = parentCommitId;
            change.name = tw.getNameString();
            tw.getObjectId(idBuf, commitIndex);
            change.objectId = AbbreviatedObjectId.fromObjectId((AnyObjectId)idBuf);
            tw.getObjectId(idBuf, parentCommitIndex);
            change.remoteObjectId = AbbreviatedObjectId.fromObjectId((AnyObjectId)idBuf);
            GitCollabCommitsModelCache.calculateAndSetChangeKind(direction, change);
            result.put(tw.getPathString(), change);
        }
        try {
            Method[] allMethods;
            Class<?> clazz = tw.getClass();
            for (Method m : allMethods = clazz.getDeclaredMethods()) {
                if (!"release".equalsIgnoreCase(m.getName()) && !"close".equalsIgnoreCase(m.getName())) continue;
                Object ret = m.invoke((Object)tw, new Object[0]);
                break;
            }
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
        return result.size() > 0 ? result : null;
    }

    private static int addTree(TreeWalk tw, RevCommit commit) throws IOException {
        if (commit != null) {
            return tw.addTree((AnyObjectId)commit.getTree());
        }
        return tw.addTree((AbstractTreeIterator)new EmptyTreeIterator());
    }

    private static AbbreviatedObjectId getAbbreviatedObjectId(RevCommit commit) {
        if (commit != null) {
            return AbbreviatedObjectId.fromObjectId((AnyObjectId)commit);
        }
        return ZERO_ID;
    }

    static void calculateAndSetChangeKind(int direction, Change change) {
        if (ZERO_ID.equals((Object)change.objectId)) {
            change.objectId = null;
            change.kind = direction | 2;
        } else if (ZERO_ID.equals((Object)change.remoteObjectId)) {
            change.remoteObjectId = null;
            change.kind = direction | 1;
        } else {
            change.kind = direction | 3;
        }
    }

    public static class Change {
        int kind;
        String name;
        AbbreviatedObjectId objectId;
        AbbreviatedObjectId commitId;
        AbbreviatedObjectId remoteCommitId;
        AbbreviatedObjectId remoteObjectId;

        Change() {
        }

        public int getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public AbbreviatedObjectId getCommitId() {
            return this.commitId;
        }

        public AbbreviatedObjectId getRemoteCommitId() {
            return this.remoteCommitId;
        }

        public AbbreviatedObjectId getObjectId() {
            return this.objectId;
        }

        public AbbreviatedObjectId getRemoteObjectId() {
            return this.remoteObjectId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.objectId == null ? 0 : this.objectId.hashCode());
            result = 31 * result + (this.remoteObjectId == null ? 0 : this.remoteObjectId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Change other = (Change)obj;
            if (this.objectId == null ? other.objectId != null : !this.objectId.equals((Object)other.objectId)) {
                return false;
            }
            return !(this.remoteObjectId == null ? other.remoteObjectId != null : !this.remoteObjectId.equals((Object)other.remoteObjectId));
        }

        public String toString() {
            StringBuilder change = new StringBuilder("Change(");
            if ((this.kind & 4) != 0) {
                change.append("INCOMING ");
            } else {
                change.append("OUTGOING ");
            }
            int changeType = this.kind & 3;
            if (changeType == 3) {
                change.append("CHANGE ");
            } else if (changeType == 1) {
                change.append("ADDITION ");
            } else if (changeType == 2) {
                change.append("DELETION ");
            }
            change.append(this.name);
            change.append(";\n\tcurrent objectId: ");
            change.append(this.getObjectId(this.objectId));
            change.append(";\n\tparent objectId: ");
            change.append(this.getObjectId(this.remoteObjectId));
            change.append(";\n\tcurrent commit: ");
            change.append(this.getObjectId(this.commitId));
            change.append(";\n\tparent commit: ");
            change.append(this.getObjectId(this.remoteCommitId));
            change.append("\n)");
            return change.toString();
        }

        private String getObjectId(AbbreviatedObjectId object) {
            if (object != null) {
                return object.toObjectId().getName();
            }
            return ObjectId.zeroId().getName();
        }
    }

    public static class Commit {
        private int direction;
        private String shortMessage;
        private AbbreviatedObjectId commitId;
        private Date commitDate;
        private String authorName;
        private String committerName;
        private Map<String, Change> children;

        public int getDirection() {
            return this.direction;
        }

        public AbbreviatedObjectId getId() {
            return this.commitId;
        }

        public String getAuthorName() {
            return this.authorName;
        }

        public String getCommitterName() {
            return this.committerName;
        }

        public Date getCommitDate() {
            return this.commitDate;
        }

        public String getShortMessage() {
            return this.shortMessage;
        }

        public Map<String, Change> getChildren() {
            return this.children;
        }

        public void dispose() {
            this.children.clear();
        }
    }
}

