/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.git;

import com.google.common.collect.Lists;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.git.GitConnectorClient;
import com.smartbear.collaborator.git.GitConnectorUtils;
import com.smartbear.collaborator.git.GitConnectorVersion;
import com.smartbear.scm.IScmLocalCheckout;
import com.smartbear.scm.IScmVersion;
import com.smartbear.scm.ScmAccessControlException;
import com.smartbear.scm.impl.git.DiffPart;
import com.smartbear.scm.impl.git.GitChangelist;
import com.smartbear.scm.impl.git.GitClientConfiguration;
import com.smartbear.scm.impl.git.GitVersion;
import com.smartbear.scm.impl.git.LogEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.lib.Repository;

public class GitConnectorChangelist
extends GitChangelist {
    Repository repository;

    public GitConnectorChangelist(GitClientConfiguration clientConfig, LogEntry entry) {
        super(clientConfig, entry);
        this.repository = ((GitConnectorClient)clientConfig).getRepository();
    }

    public List<IScmVersion> getVersions(IProgressMonitor monitor) throws ScmCommunicationException {
        return Lists.newArrayList(this.getVersions());
    }

    public List<GitVersion> getVersions() throws ScmCommunicationException {
        if (this.repository == null) {
            throw new ScmCommunicationException("No Repository is found!");
        }
        try {
            ArrayList versions = Lists.newArrayList();
            List<DiffPart> parts = new ArrayList();
            if (this.origin != null) {
                this.fillOriginCommitInfo(this.origin);
                GitConnectorUtils.fillDiffPartsByObjectIds(this.repository, this.repository.resolve(this.entry.commit), this.repository.resolve(this.origin), parts);
            } else {
                parts = this.entry.diffs;
                this.originCommitInfo = this.entry.toCommitInfo();
            }
            for (DiffPart part : parts) {
                versions.add(new GitConnectorVersion(part, this, true, this.repository));
            }
            return versions;
        }
        catch (IOException e) {
            throw new ScmCommunicationException(e.getMessage());
        }
    }

    private void fillOriginCommitInfo(String commit) throws ScmCommunicationException {
        LogEntry originLog = GitConnectorUtils.getGitLogEntry(this.repository, commit, null);
        this.originCommitInfo = originLog.toCommitInfo();
    }

    public List<IScmLocalCheckout> getLocalCheckouts(IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public void checkAccessPermission(String userLogin, IProgressMonitor monitor) throws ScmCommunicationException, ScmAccessControlException {
        if (this.originCommitInfo != null) {
            this.originCommitInfo.setAuthor(userLogin);
        }
        if (this.targetCommitInfo != null) {
            this.targetCommitInfo.setAuthor(userLogin);
        }
    }
}

