/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.git;

import com.google.common.collect.Lists;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.git.GitCollabCommitsModelCache;
import com.smartbear.collaborator.git.GitConnectorChangelist;
import com.smartbear.collaborator.git.GitConnectorDiffCommand;
import com.smartbear.collaborator.git.GitConnectorDiffVersion;
import com.smartbear.collaborator.git.GitConnectorLocalCheckout;
import com.smartbear.collaborator.git.GitConnectorUtils;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.IScmConnectionParameters;
import com.smartbear.scm.IScmLocalCheckout;
import com.smartbear.scm.IScmVersion;
import com.smartbear.scm.ScmChangeset;
import com.smartbear.scm.ScmConfigurationException;
import com.smartbear.scm.impl.common.ScmConnectionParameters;
import com.smartbear.scm.impl.git.DiffPart;
import com.smartbear.scm.impl.git.GitClientConfiguration;
import com.smartbear.scm.impl.git.GitLocalCheckoutUnmodified;
import com.smartbear.scm.impl.git.GitVersion;
import com.smartbear.scm.impl.git.LogEntry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.synchronize.GitCommitsModelCache;
import org.eclipse.egit.core.synchronize.StagedChangeCache;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;

public class GitConnectorClient
extends GitClientConfiguration {
    private static final int CHANGE_TYPE_MASK = 3;
    private static final int ADDITION = 1;
    private static final int DELETION = 2;
    private static final int CHANGE = 3;
    private static final Log LOG = LogFactory.getLog(GitConnectorClient.class);
    Repository repository;
    List<String> branches;

    public GitConnectorClient(Repository repository) {
        super(repository.getWorkTree());
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setBranches(List<String> branches) {
        this.branches = branches;
    }

    public List<String> listBranches(IProgressMonitor monitor) throws ScmCommunicationException {
        return this.branches;
    }

    public List<IScmLocalCheckout> getModifiedFiles(File directory, IProgressMonitor monitor) throws ScmCommunicationException {
        LogEntry head = GitConnectorUtils.getGitLogEntry(this.repository, null, null);
        Map resultFromStaged = StagedChangeCache.build((Repository)this.repository);
        HashMap<String, GitCollabCommitsModelCache.Change> result = new HashMap<String, GitCollabCommitsModelCache.Change>();
        for (String key : resultFromStaged.keySet()) {
            GitCommitsModelCache.Change change = (GitCommitsModelCache.Change)resultFromStaged.get(key);
            GitCollabCommitsModelCache.Change newChange = new GitCollabCommitsModelCache.Change();
            newChange.commitId = change.getCommitId();
            newChange.kind = change.getKind();
            newChange.name = change.getName();
            newChange.objectId = change.getObjectId();
            newChange.remoteCommitId = change.getRemoteCommitId();
            newChange.remoteObjectId = change.getRemoteObjectId();
            result.put(key, newChange);
        }
        ArrayList<DiffPart> diffParts = new ArrayList<DiffPart>();
        GitConnectorUtils.fillDiffParts(result, diffParts);
        ArrayList modified = Lists.newArrayList();
        for (DiffPart part : diffParts) {
            modified.add(new GitConnectorLocalCheckout(this.repository, this, part, head));
        }
        return modified;
    }

    private String getFirstCommitString() throws ScmConfigurationException {
        try {
            LogCommand log = new Git(this.repository).log();
            Iterator it = log.call().iterator();
            RevCommit firstCommit = null;
            while (it.hasNext()) {
                firstCommit = (RevCommit)it.next();
            }
            if (firstCommit == null || firstCommit.getParentCount() > 0) {
                throw new ScmConfigurationException("No first commit");
            }
            return GitConnectorUtils.parserString(firstCommit.toString());
        }
        catch (GitAPIException e) {
            throw new ScmConfigurationException(e.getMessage());
        }
    }

    public String getDisplayableConfiguration() {
        return "GIT_DIR=" + this.checkout.getAbsolutePath();
    }

    public IScmConnectionParameters getServerConfiguration(IScmLocalCheckout checkout, IScmVersion version, IScmChangelist atomicChange) throws ScmConfigurationException, ScmCommunicationException {
        ScmConnectionParameters connectionParams = new ScmConnectionParameters();
        StoredConfig config = this.repository.getConfig();
        String originUrl = config.getString("remote", "origin", "url");
        connectionParams.setConfigA(originUrl);
        String firstCommit = this.getFirstCommitString();
        connectionParams.setConfigB(firstCommit);
        return connectionParams;
    }

    public String getUserName() {
        StoredConfig config = this.repository.getConfig();
        String username = config.getString("user", null, "name");
        return username;
    }

    public IScmChangelist getChangelist(String revspec, IProgressMonitor monitor) throws ScmCommunicationException {
        LogEntry logEntry = GitConnectorUtils.getGitLogEntry(this.repository, revspec, null);
        return new GitConnectorChangelist(this, logEntry);
    }

    public ScmChangeset getChangesetFromDiffs(final String userLogin, List<String> userDiffArgs, IProgressMonitor monitor) throws ScmCommunicationException {
        try {
            if (userDiffArgs == null || userDiffArgs.size() != 2) {
                throw new ScmCommunicationException("No two branches are input to compare the difference!");
            }
            ScmChangeset cs = new ScmChangeset(){

                public Set<String> getAuthors() {
                    HashSet<String> authors = new HashSet<String>();
                    authors.add(userLogin);
                    return authors;
                }

                public Set<String> getComments() {
                    return Collections.emptySet();
                }
            };
            AbstractTreeIterator oldTreeParser = GitConnectorClient.prepareTreeParser(this.repository, userDiffArgs.get(0));
            AbstractTreeIterator newTreeParser = GitConnectorClient.prepareTreeParser(this.repository, userDiffArgs.get(1));
            GitConnectorDiffCommand diffCommand = new GitConnectorDiffCommand(this.repository);
            diffCommand.setOldTree(oldTreeParser);
            diffCommand.setNewTree(newTreeParser);
            Object diff = diffCommand.call();
            Iterator iterator = diff.iterator();
            while (iterator.hasNext()) {
                DiffEntry entry = (DiffEntry)iterator.next();
                GitConnectorDiffVersion target = null;
                GitConnectorDiffVersion origin = null;
                target = new GitConnectorDiffVersion(this.repository, this, entry.getNewPath(), entry.getId(DiffEntry.Side.NEW).name(), null);
                origin = new GitConnectorDiffVersion(this.repository, this, entry.getOldPath(), entry.getId(DiffEntry.Side.OLD).name(), null);
                cs.addChange((IScmVersion)origin, (IScmVersion)target);
            }
            return cs;
        }
        catch (IOException e) {
            throw new ScmCommunicationException(e.getMessage());
        }
        catch (GitAPIException e) {
            throw new ScmCommunicationException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractTreeIterator prepareTreeParser(Repository repository, String ref) throws IOException, MissingObjectException, IncorrectObjectTypeException {
        Ref head = repository.findRef(ref);
        RevWalk walk = new RevWalk(repository);
        RevCommit commit = walk.parseCommit((AnyObjectId)head.getObjectId());
        RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
        CanonicalTreeParser oldTreeParser = new CanonicalTreeParser();
        try (ObjectReader oldReader = repository.newObjectReader();){
            oldTreeParser.reset(oldReader, (AnyObjectId)tree.getId());
        }
        walk.dispose();
        return oldTreeParser;
    }

    public IScmLocalCheckout getLocalCheckout(File path, IProgressMonitor monitor) throws ScmCommunicationException {
        RepositoryBuilder builder = new RepositoryBuilder();
        String gitFilePath = GitConnectorUtils.getRepoRelativePath(this.repository, path.getAbsolutePath());
        LogEntry log = GitConnectorUtils.getGitLogEntry(this.repository, null, gitFilePath);
        if (log == null) {
            return null;
        }
        GitConnectorChangelist changelist = new GitConnectorChangelist(this, log);
        GitVersion baseVersion = null;
        List versions = changelist.getVersions();
        LOG.info((Object)("Path: " + path.getAbsolutePath() + "\n"));
        for (GitVersion version : versions) {
            File pathTesterFull = new File(this.checkout.getAbsolutePath(), version.getDepotPath());
            LOG.debug((Object)("Potential Full Path: " + pathTesterFull));
            if (!path.getAbsolutePath().equals(pathTesterFull.getAbsolutePath())) continue;
            LOG.debug((Object)("Found full path version: " + pathTesterFull.getAbsolutePath() + "\n"));
            baseVersion = version;
            break;
        }
        if (baseVersion == null) {
            throw new ScmCommunicationException("Unable to find path for: " + path);
        }
        return new GitLocalCheckoutUnmodified((GitClientConfiguration)this, baseVersion, path);
    }
}

