/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.git;

import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.git.BlobStorage;
import com.smartbear.collaborator.git.GitCollabCommitsModelCache;
import com.smartbear.collaborator.git.GitConnectorLogEntry;
import com.smartbear.scm.impl.git.DiffPart;
import com.smartbear.scm.impl.git.LogEntry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitConnectorUtils {
    private static final int CHANGE_TYPE_MASK = 3;
    private static final int ADDITION = 1;
    private static final int DELETION = 2;
    private static final int CHANGE = 3;

    public static LogEntry convertRevCommitToLogEntry(Repository repository, RevCommit revCommit) throws ScmCommunicationException {
        try {
            GitConnectorLogEntry logEntry = new GitConnectorLogEntry();
            logEntry.commit = GitConnectorUtils.parserString(revCommit.toString());
            logEntry.tree = GitConnectorUtils.parserString(revCommit.getTree() == null ? null : revCommit.getTree().toString());
            PersonIdent personIndent = revCommit.getAuthorIdent();
            logEntry.author = personIndent.getName();
            logEntry.date = personIndent.getWhen();
            String committer = revCommit.getCommitterIdent().toString();
            logEntry.committer = committer.substring("PersonIdent[".length(), committer.length() - 1);
            for (RevCommit commit : revCommit.getParents()) {
                logEntry.parents.add(GitConnectorUtils.parserString(commit.toString()));
            }
            logEntry.message = revCommit.getFullMessage();
            String parent = null;
            logEntry.diffs = new ArrayList();
            if (logEntry.parents != null && !logEntry.parents.isEmpty()) {
                parent = (String)logEntry.parents.get(0);
                GitConnectorUtils.fillDiffPartsByObjectIds(repository, repository.resolve(logEntry.commit), repository.resolve(parent), logEntry.diffs);
            } else {
                GitConnectorUtils.fillDiffPartsByObjectIds(repository, repository.resolve(logEntry.commit), null, logEntry.diffs);
            }
            return logEntry;
        }
        catch (IOException e) {
            throw new ScmCommunicationException(e.getMessage());
        }
    }

    public static void fillDiffPartsByObjectIds(Repository repository, ObjectId currentId, ObjectId parentId, List<DiffPart> diffParts) throws ScmCommunicationException {
        if (currentId == null) {
            return;
        }
        try {
            List<GitCollabCommitsModelCache.Commit> rightResult = GitCollabCommitsModelCache.build(repository, currentId, parentId, null);
            for (GitCollabCommitsModelCache.Commit commit : rightResult) {
                Map<String, GitCollabCommitsModelCache.Change> result = commit.getChildren();
                ArrayList<DiffPart> diffs = new ArrayList<DiffPart>();
                GitConnectorUtils.fillDiffParts(result, diffs);
                diffParts.addAll(diffs);
            }
        }
        catch (IOException e) {
            throw new ScmCommunicationException(e.getMessage());
        }
    }

    public static void fillDiffParts(Map<String, GitCollabCommitsModelCache.Change> result, List<DiffPart> diffParts) {
        for (String key : result.keySet()) {
            DiffPart diff = new DiffPart();
            GitCollabCommitsModelCache.Change c = result.get(key);
            int changeType = c.getKind() & 3;
            switch (changeType) {
                case 1: {
                    diff.op = "A";
                    break;
                }
                case 2: {
                    diff.op = "D";
                    break;
                }
                case 3: {
                    diff.op = "M";
                    break;
                }
                default: {
                    diff.op = "M";
                }
            }
            diff.origin.hash = c.getRemoteObjectId() == null ? null : c.getRemoteObjectId().name();
            diff.origin.path = key;
            diff.target.hash = c.getObjectId() == null ? null : c.getObjectId().name();
            diff.target.path = key;
            diffParts.add(diff);
        }
    }

    public static String parserString(String input) {
        if (input == null) {
            return "";
        }
        String[] values = StringUtils.split((String)input);
        if (values != null && values.length > 1 && values[1] != null) {
            return values[1];
        }
        return "";
    }

    public static byte[] getContent(Repository repository, String content, String path) throws ScmCommunicationException {
        try {
            ObjectId contentId = repository.resolve(content);
            BlobStorage blobStorage = new BlobStorage(repository, path, contentId);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)blobStorage.getContents(), (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new ScmCommunicationException((Exception)e);
        }
        catch (CoreException e) {
            throw new ScmCommunicationException((Exception)((Object)e));
        }
    }

    public static LogEntry getGitLogEntry(Repository repository, String commit, String gitFilePath) throws ScmCommunicationException {
        try {
            LogCommand log = new Git(repository).log();
            Iterator it = gitFilePath == null ? log.call().iterator() : log.addPath(gitFilePath).call().iterator();
            RevCommit revCommit = null;
            boolean found = false;
            while (it.hasNext()) {
                revCommit = (RevCommit)it.next();
                if (commit == null) {
                    LogEntry logEntry = GitConnectorUtils.convertRevCommitToLogEntry(repository, revCommit);
                    return logEntry;
                }
                if (!GitConnectorUtils.parserString(revCommit.toString()).contains(commit)) continue;
                found = true;
                break;
            }
            if (!found) {
                if (commit == null && gitFilePath == null) {
                    throw new ScmCommunicationException("Could not find the corresponding commit!");
                }
                return null;
            }
            LogEntry logEntry = GitConnectorUtils.convertRevCommitToLogEntry(repository, revCommit);
            return logEntry;
        }
        catch (GitAPIException e) {
            throw new ScmCommunicationException(e.getMessage());
        }
    }

    public static String getRepoRelativePath(Repository repository, String path) {
        String workdirPrefix;
        try {
            workdirPrefix = repository.getWorkTree().getCanonicalPath();
        }
        catch (IOException err) {
            workdirPrefix = repository.getWorkTree().getAbsolutePath();
        }
        int pfxLen = workdirPrefix.length();
        int pLen = path.length();
        if (pLen > pfxLen) {
            return path.substring(pfxLen + 1).replace('\\', '/');
        }
        if (path.length() == pfxLen - 1) {
            return "";
        }
        return null;
    }
}

