/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.git;

import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.git.GitConnectorUtils;
import com.smartbear.scm.IScmVersion;
import com.smartbear.scm.impl.git.DiffPart;
import com.smartbear.scm.impl.git.GitChangelist;
import com.smartbear.scm.impl.git.GitVersion;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.lib.Repository;

public class GitConnectorVersion
extends GitVersion {
    Repository repository;

    public GitConnectorVersion(DiffPart part, GitChangelist changelist, boolean target, Repository repository) {
        super(part, changelist, target);
        this.repository = repository;
    }

    public byte[] getContent(int maxContentSize, IProgressMonitor monitor) throws ScmCommunicationException {
        String content = this.getVersion();
        if (content == null || content.matches("0{40}")) {
            return null;
        }
        String path = this.target ? this.part.target.path : this.part.origin.path;
        return GitConnectorUtils.getContent(this.repository, content, path);
    }

    public List<IScmVersion> getHistory(int numVersions, IProgressMonitor monitor) throws ScmCommunicationException {
        if (!this.target) {
            return Collections.singletonList(this);
        }
        if (this.part.op.equals("A")) {
            return Collections.singletonList(this);
        }
        return Arrays.asList(new IScmVersion[]{this, new GitConnectorVersion(this.part, this.changelist, false, this.repository)});
    }
}

