/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.subclipse;

import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.team.ResourceScmClientConfigurationWrapper;
import com.smartbear.collaborator.ui.subclipse.SubclipseClientConfigFactory;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.ScmConfigurationException;
import com.smartbear.scm.impl.subversion.SubversionClientConfiguration;
import com.smartbear.util.commons.ArrayUtils;
import java.util.Arrays;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.tigris.subversion.subclipse.core.history.ILogEntry;

public class RevisionAdapterFactory
implements IAdapterFactory {
    static final Class[] ADAPTER_LIST = new Class[]{IScmChangelist.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!(adaptableObject instanceof ILogEntry)) {
            throw new RuntimeException("Should only be asked for adapters to ILogEntry");
        }
        ILogEntry revision = (ILogEntry)adaptableObject;
        if (!ArrayUtils.contains((Object[])ADAPTER_LIST, (Object)adapterType)) {
            throw new RuntimeException("Should only be asked for " + Arrays.asList(ADAPTER_LIST));
        }
        if (adapterType == IScmChangelist.class) {
            SubversionClientConfiguration clientConfig;
            try {
                ResourceScmClientConfigurationWrapper wrapperClientConfig = (ResourceScmClientConfigurationWrapper)SubclipseClientConfigFactory.getClientConfiguration(revision.getResource().getRepository(), (IProgressMonitor)new NullProgressMonitor());
                clientConfig = (SubversionClientConfiguration)wrapperClientConfig.getWrappedClientConfig();
            }
            catch (ScmConfigurationException e) {
                Collaborator.log((String)("Could not get IScmChangelist for Revision " + revision), (Throwable)e);
                return null;
            }
            try {
                return clientConfig.getChangelist(revision.getRevision().toString(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ScmCommunicationException e) {
                Collaborator.log((String)("Could not get IScmChangelist for Revision " + revision), (Throwable)e);
                return null;
            }
        }
        throw new RuntimeException("Unexpected adapterType");
    }

    public Class[] getAdapterList() {
        return ADAPTER_LIST;
    }
}

