/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.subclipse;

import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.ScmOptions;
import com.smartbear.collaborator.subclipse.SubclipseSubversionClient;
import com.smartbear.collaborator.team.IResourceScmClientConfiguration;
import com.smartbear.collaborator.team.ResourceScmClientConfigurationWrapper;
import com.smartbear.collaborator.team.scm.IResourceScmClientConfigurationFactory;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.ScmConfigurationException;
import com.smartbear.scm.impl.subversion.ISubversionClient;
import com.smartbear.scm.impl.subversion.SubversionClientConfiguration;
import com.smartbear.scm.impl.subversion.SubversionSystem;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.NotificationListener;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;

public class SubclipseClientConfigFactory
implements IResourceScmClientConfigurationFactory {
    public IResourceScmClientConfiguration getClientConfiguration(RepositoryProvider provider, IProgressMonitor monitor) throws ScmConfigurationException {
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)provider.getProject());
        ISVNRepositoryLocation remoteLocation = svnResource.getRepository();
        if (remoteLocation == null) {
            throw new ScmConfigurationException("Cannot get Subversion information for provider " + provider);
        }
        return SubclipseClientConfigFactory.getClientConfiguration(remoteLocation, monitor);
    }

    public static IResourceScmClientConfiguration getClientConfiguration(ISVNRepositoryLocation remoteLocation, IProgressMonitor monitor) throws ScmConfigurationException {
        ISVNClientAdapter svnClientAdapter;
        try {
            svnClientAdapter = remoteLocation.getSVNClient();
        }
        catch (SVNException e) {
            throw new ScmConfigurationException("Could not get client adapter for " + remoteLocation.getLabel(), (Throwable)e);
        }
        svnClientAdapter.removeNotifyListener((ISVNNotifyListener)NotificationListener.getInstance());
        SubclipseSubversionClient svnClient = new SubclipseSubversionClient(svnClientAdapter);
        ScmOptions options = new ScmOptions();
        options.setScm("subversion");
        options.setSvnAutoAdd(Boolean.valueOf(true));
        options.setSvnRecurseExternals(Boolean.valueOf(true));
        options.setSvnRepoUrl(remoteLocation.getUrl().toString());
        SubversionClientConfiguration clientConfig = SubversionSystem.INSTANCE.getClientConfiguration((ISubversionClient)svnClient, (IScmOptions)options, monitor);
        ResourceScmClientConfigurationWrapper resourceClientConfig = new ResourceScmClientConfigurationWrapper((IScmClientConfiguration)clientConfig);
        return resourceClientConfig;
    }
}

