/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.subversive;

import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.ScmOptions;
import com.smartbear.collaborator.subversive.SVNConnectorSubversionClient;
import com.smartbear.collaborator.team.IResourceScmClientConfiguration;
import com.smartbear.collaborator.team.ResourceScmClientConfigurationWrapper;
import com.smartbear.collaborator.team.scm.IResourceScmClientConfigurationFactory;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.ScmConfigurationException;
import com.smartbear.scm.impl.subversion.ISubversionClient;
import com.smartbear.scm.impl.subversion.SubversionClientConfiguration;
import com.smartbear.scm.impl.subversion.SubversionSystem;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.SVNTeamProvider;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;

public class SubversiveClientConfigurationFactory
implements IResourceScmClientConfigurationFactory {
    public IResourceScmClientConfiguration getClientConfiguration(RepositoryProvider provider, IProgressMonitor monitor) throws ScmConfigurationException {
        if (!(provider instanceof SVNTeamProvider)) {
            throw new RuntimeException("Expected SVNTeamProvider: " + provider);
        }
        SVNTeamProvider svnProvider = (SVNTeamProvider)provider;
        IRepositoryLocation repositoryLocation = svnProvider.getRepositoryLocation();
        return new ResourceScmClientConfigurationWrapper((IScmClientConfiguration)SubversiveClientConfigurationFactory.getClientConfiguration(repositoryLocation, SubversiveClientConfigurationFactory.getScmOptions(repositoryLocation), monitor));
    }

    public static SubversionClientConfiguration getClientConfiguration(IRepositoryLocation repositoryLocation, IScmOptions options, IProgressMonitor monitor) throws ScmConfigurationException {
        SVNConnectorSubversionClient client = new SVNConnectorSubversionClient(repositoryLocation);
        return SubversionSystem.INSTANCE.getClientConfiguration((ISubversionClient)client, options, monitor);
    }

    public static IScmOptions getScmOptions(IRepositoryLocation repositoryLocation) {
        ScmOptions options = new ScmOptions();
        options.setScm("subversion");
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        boolean isSelectNewResources = SVNTeamPreferences.getBehaviourBoolean((IPreferenceStore)store, (String)"resourceSelection.selectNew");
        options.setSvnAutoAdd(Boolean.valueOf(isSelectNewResources));
        boolean isDoNotSelectExternals = SVNTeamPreferences.getBehaviourBoolean((IPreferenceStore)store, (String)"resourceSelection.treatExternalAsLocal");
        options.setSvnRecurseExternals(Boolean.valueOf(!isDoNotSelectExternals));
        options.setSvnRepoUrl(repositoryLocation.getUrl());
        return options;
    }
}

