/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.subversive.handlers;

import com.smartbear.beans.IScmOptions;
import com.smartbear.collaborator.ui.ide.actions.AbstractAddToReviewHandler;
import com.smartbear.collaborator.ui.subversive.SubversiveClientConfigurationFactory;
import com.smartbear.collaborator.ui.subversive.wizards.RevisionsSelectionPage;
import com.smartbear.collaborator.ui.util.PlatformUIUtils;
import com.smartbear.collaborator.ui.wizards.IChangesSelectionPage;
import com.smartbear.scm.ScmConfigurationException;
import com.smartbear.scm.impl.subversion.SubversionClientConfiguration;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.history.SVNHistoryPage;
import org.eclipse.team.svn.ui.history.model.SVNLogNode;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddRevisionToReviewHandler
extends AbstractAddToReviewHandler
implements IHandler {
    public AddRevisionToReviewHandler() {
        super("Add Revisions");
    }

    public void setEnabled(Object evaluationContext) {
        List selection = PlatformUIUtils.getMultiSelection((IEvaluationContext)((IEvaluationContext)evaluationContext), SVNLogNode.class);
        for (SVNLogNode logEntry : selection) {
            if (logEntry.getRevision() > 0L) continue;
            this.setBaseEnabled(false);
            return;
        }
        this.setBaseEnabled(true);
    }

    protected IChangesSelectionPage getChangesSelectionPage(ExecutionEvent event) throws ExecutionException {
        SubversionClientConfiguration clientConfig;
        IWorkbenchPart activePart = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        IHistoryView historyView = (IHistoryView)activePart;
        IHistoryPage historyPage = historyView.getHistoryPage();
        SVNHistoryPage svnHistoryPage = (SVNHistoryPage)historyPage;
        IRepositoryResource repositoryResource = svnHistoryPage.getRepositoryResource();
        IRepositoryLocation repositoryLocation = repositoryResource.getRepositoryLocation();
        IScmOptions options = SubversiveClientConfigurationFactory.getScmOptions(repositoryLocation);
        try {
            clientConfig = SubversiveClientConfigurationFactory.getClientConfiguration(repositoryLocation, options, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ScmConfigurationException e) {
            throw new ExecutionException("Error loading client config", (Throwable)e);
        }
        List selection = PlatformUIUtils.getMultiSelection((ExecutionEvent)event, SVNLogNode.class);
        return new RevisionsSelectionPage(clientConfig, options, svnHistoryPage, selection);
    }
}

