/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.subversive.wizards;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.smartbear.beans.IScmOptions;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.ui.wizards.AtomicChangesSelectionPage;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.impl.subversion.SubversionClientConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.history.ISVNHistoryViewInfo;
import org.eclipse.team.svn.ui.history.LogMessagesComposite;
import org.eclipse.team.svn.ui.history.SVNHistoryPage;
import org.eclipse.team.svn.ui.history.data.SVNLocalFileRevision;
import org.eclipse.team.svn.ui.history.model.SVNLogNode;

public class RevisionsSelectionPage
extends AtomicChangesSelectionPage {
    private final SubversionClientConfiguration clientConfig;
    private final SVNHistoryPage historyPage;
    private Composite borderComposite;

    public RevisionsSelectionPage(SubversionClientConfiguration clientConfig, IScmOptions options, SVNHistoryPage historyPage, List<SVNLogNode> defaultSelection) {
        super("Revisions", options);
        this.clientConfig = clientConfig;
        this.historyPage = historyPage;
        this.setDefaultSelection((IStructuredSelection)new StructuredSelection(defaultSelection));
    }

    protected Control getTopControl() {
        return this.borderComposite;
    }

    protected StructuredViewer createViewer(Composite parent) {
        this.borderComposite = new Composite(parent, 2048);
        this.borderComposite.setLayout((Layout)new FillLayout());
        LogMessagesComposite logMessages = new LogMessagesComposite(this.borderComposite, true, false, (ISVNHistoryViewInfo)new FilteredHistoryViewInfo((ISVNHistoryViewInfo)this.historyPage));
        logMessages.refresh(3);
        CheckboxTreeViewer viewer = logMessages.getTreeViewer();
        viewer.setSelection((ISelection)this.getDefaultSelection(), true);
        return viewer;
    }

    protected IScmChangelist toAtomicChange(Object element) {
        try {
            return this.clientConfig.getChangelist(Long.toString(((SVNLogNode)element).getRevision()), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ScmCommunicationException e) {
            throw new RuntimeException("Could not get IScmChangelist for element " + element, e);
        }
    }

    private static class FilteredHistoryViewInfo
    implements ISVNHistoryViewInfo {
        private static final SVNLogEntry[] EMPTY_LOG_ENTRY_ARRAY = new SVNLogEntry[0];
        private final ISVNHistoryViewInfo info;

        public FilteredHistoryViewInfo(ISVNHistoryViewInfo info) {
            this.info = info;
        }

        public IResource getResource() {
            return this.info.getResource();
        }

        public IRepositoryResource getRepositoryResource() {
            return this.info.getRepositoryResource();
        }

        public long getCurrentRevision() {
            return this.info.getCurrentRevision();
        }

        public boolean isPending() {
            return this.info.isPending();
        }

        public boolean isRelatedPathsOnly() {
            return this.info.isRelatedPathsOnly();
        }

        public boolean isGrouped() {
            return this.info.isGrouped();
        }

        public int getMode() {
            return this.info.getMode();
        }

        public SVNLocalFileRevision[] getLocalHistory() {
            return this.info.getLocalHistory();
        }

        public SVNLogEntry[] getRemoteHistory() {
            ArrayList history = Arrays.asList(this.info.getRemoteHistory());
            history = Lists.newArrayList((Iterable)Iterables.filter(history, (Predicate)new Predicate<SVNLogEntry>(){

                public boolean apply(SVNLogEntry logEntry) {
                    return logEntry.revision > 0L;
                }
            }));
            return history.toArray(EMPTY_LOG_ENTRY_ARRAY);
        }
    }
}

