/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.clearcase;

import com.smartbear.beans.IAskUser;
import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.NullAskUser;
import com.smartbear.beans.ScmOptions;
import com.smartbear.collaborator.team.IResourceScmClientConfiguration;
import com.smartbear.collaborator.team.ResourceScmClientConfigurationWrapper;
import com.smartbear.collaborator.team.scm.IResourceScmClientConfigurationFactory;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.IScmSystem;
import com.smartbear.scm.ScmConfigurationException;
import com.smartbear.scm.ScmUtils;
import com.smartbear.scm.impl.clearcase.ClearCaseSystem;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;

public class ClearcaseClientConfigFactory
implements IResourceScmClientConfigurationFactory {
    public IResourceScmClientConfiguration getClientConfiguration(RepositoryProvider provider, IProgressMonitor monitor) throws ScmConfigurationException {
        IScmClientConfiguration clientConfig;
        IPath location;
        File checkout = null;
        IProject project = provider.getProject();
        if (project != null && (location = project.getLocation()) != null) {
            checkout = location.toFile();
        }
        if (checkout != null) {
            clientConfig = ClearCaseSystem.INSTANCE.getClientConfiguration(checkout, ScmOptions.create((String)"clearcase"), (IAskUser)NullAskUser.INSTANCE, (IProgressMonitor)new NullProgressMonitor());
            if (clientConfig == null) {
                throw new ScmConfigurationException("Could not get ClearCase configuration for " + checkout);
            }
        } else {
            clientConfig = ScmUtils.requireScm((IScmSystem)ClearCaseSystem.INSTANCE, (IScmOptions)new ScmOptions(), (IAskUser)NullAskUser.INSTANCE, (IProgressMonitor)monitor);
        }
        ResourceScmClientConfigurationWrapper resourceClientConfig = new ResourceScmClientConfigurationWrapper(clientConfig);
        return resourceClientConfig;
    }
}

