/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.ide;

import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.NoLicenseAvailableException;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewSummary;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.JsonAPIHandler;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.preferences.PrefsHelper;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.editors.ReviewEditorInput;
import com.smartbear.collections.ClosureReturn;
import com.smartbear.util.SmartBearUtils;
import java.net.URL;
import java.text.ParseException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public enum CollaboratorIDEUI {

    public static final String ID = "com.smartbear.collaborator.ui.ide";
    public static final String DECORATOR_ID = "com.smartbear.collaborator.ui.ide.reviewdecorator";

    public static void showActionItemsView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    page.showView("com.smartbear.collaborator.ui.views.ActionItemsView");
                }
                catch (PartInitException e) {
                    CollaboratorUI.log((String)"Could not show action items view", (Throwable)e);
                }
            }
        });
    }

    public static Throwable openReview(final IWorkbenchWindow window, final int reviewId) {
        final ClosureReturn error = new ClosureReturn();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DMReviewSummary reviewSummary;
                if (PrefsHelper.getPrefs().getReviewInEclipse()) {
                    CollaboratorIDEUI.showPerspective();
                    ReviewEditorInput reviewEditorInput = new ReviewEditorInput(reviewId);
                    try {
                        IWorkbenchPage activePage = window.getActivePage();
                        if (activePage == null) {
                            activePage = (IWorkbenchPage)SmartBearUtils.getFirstObject((Object[])window.getPages());
                        }
                        activePage.openEditor((IEditorInput)reviewEditorInput, "com.smartbear.collaborator.ui.editors.ReviewEditor");
                    }
                    catch (PartInitException e) {
                        error.set((Object)e);
                        return;
                    }
                }
                try {
                    reviewSummary = JsonAPIHandler.getReviewSummary((int)reviewId);
                }
                catch (CollabClientServerConnectivityException e) {
                    error.set((Object)e);
                    return;
                }
                catch (NoLicenseAvailableException e) {
                    error.set((Object)e);
                    return;
                }
                catch (ParseException e) {
                    error.set((Object)e);
                    return;
                }
                catch (CollabClientException e) {
                    error.set((Object)e);
                    return;
                }
                CollaboratorIDEUI.openInBrowser(Collaborator.getUrl((IReviewSummary)reviewSummary));
            }
        });
        return (Throwable)error.get();
    }

    public static void openInBrowser(URL url) {
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = browserSupport.createBrowser(32, url.toString(), "Collaborator", null);
            browser.openURL(url);
        }
        catch (PartInitException e) {
            CollaboratorUI.openError((Shell)CollaboratorUI.getShell(), (String)("Error opening browser for " + url), (Throwable)e, (boolean)false, (boolean)false);
        }
    }

    public static void showPerspective() {
        boolean showPerspective;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if ("com.smartbear.collaborator.ui.collabPerspective".equals(activeWorkbenchWindow.getActivePage().getPerspective().getId())) {
            return;
        }
        String switchPreference = PrefsHelper.getPrefs().getSwitchPerspective();
        if (switchPreference == null || "prompt".equals(switchPreference)) {
            ScopedPreferenceStore prefStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.smartbear.collaborator");
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)activeWorkbenchWindow.getShell(), (String)"Confirm Open Perspective", (String)"The Collaborator Review Editor is associated with the Collaborator Perspective.  Do you want to open that perspective now?", null, (boolean)false, (IPreferenceStore)prefStore, (String)"switchPerspective");
            showPerspective = dialog.getReturnCode() == 2;
        } else {
            showPerspective = "always".equals(switchPreference);
        }
        if (showPerspective) {
            try {
                workbench.showPerspective("com.smartbear.collaborator.ui.collabPerspective", activeWorkbenchWindow);
            }
            catch (WorkbenchException e) {
                CollaboratorUI.log((String)("Couldn't open " + Product.current.getProductName() + " perspective"), (Throwable)e);
            }
        }
    }

    public static Shell getDefaultShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

