/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.ide.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.smartbear.collaborator.preferences.PrefsHelper;
import com.smartbear.collaborator.resources.ResourcesUtil;
import com.smartbear.collaborator.team.ClientConfigurationManager;
import com.smartbear.collaborator.team.IResourceScmClientConfiguration;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ide.actions.AbstractAddToReviewHandler;
import com.smartbear.collaborator.ui.ide.wizards.WorkspaceChangesSelectionPage;
import com.smartbear.collaborator.ui.util.PlatformUIUtils;
import com.smartbear.collaborator.ui.wizards.IChangesSelectionPage;
import com.smartbear.scm.ScmConfigurationException;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class AddResourcesToReviewHandler
extends AbstractAddToReviewHandler {
    static final Predicate<ISynchronizeModelElement> INCOMING_SYNC_PREDICATE = new Predicate<ISynchronizeModelElement>(){

        public boolean apply(ISynchronizeModelElement element) {
            return (element.getKind() & 0xC) == 8;
        }
    };
    private List<IResource> selectionResources;
    private ClientConfigurationManager clientConfigManager;

    public AddResourcesToReviewHandler() {
        super("Add files");
    }

    public void setEnabled(Object evaluationContext) {
        List selection = PlatformUIUtils.getMultiSelection((IEvaluationContext)((IEvaluationContext)evaluationContext), ISynchronizeModelElement.class);
        this.setBaseEnabled(!Iterables.any((Iterable)selection, INCOMING_SYNC_PREDICATE));
    }

    private List<IResource> getSelectionResources(ExecutionEvent event) throws ExecutionException {
        LinkedHashSet resources = Sets.newLinkedHashSet();
        resources.addAll(PlatformUIUtils.getMultiSelection((ExecutionEvent)event, IResource.class));
        try {
            resources.addAll(ResourcesUtil.toResources((List)PlatformUIUtils.getMultiSelection((ExecutionEvent)event, ResourceMapping.class)));
        }
        catch (CoreException e) {
            throw new ExecutionException("Could not get Files for Add to Review Wizard", (Throwable)e);
        }
        for (ISynchronizeModelElement syncElement : PlatformUIUtils.getMultiSelection((ExecutionEvent)event, ISynchronizeModelElement.class)) {
            IResource resource = syncElement.getResource();
            if (resource == null) continue;
            resources.add(resource);
        }
        return Lists.newArrayList((Iterable)resources);
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        PlatformUI.getWorkbench().saveAllEditors(true);
        this.selectionResources = this.getSelectionResources(event);
        this.clientConfigManager = new ClientConfigurationManager();
        boolean foundUnsupportedSCM = false;
        for (IResource resource : this.selectionResources) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject());
            try {
                if (this.clientConfigManager.isSupportedSCM(provider) || foundUnsupportedSCM || !PrefsHelper.getPrefs().getWarnUnsupportedSCM()) continue;
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unsupported SCM System or Client", (String)"Some of the files you have selected are managed by an SCM System or SCM client that is not supported by this version of Collaborator.  They will be treated as uncontrolled files.", (String)"Don't display this warning again", (boolean)false, null, null);
                if (dialog.getToggleState()) {
                    IEclipsePreferences prefsNode = PrefsHelper.getEclipsePrefsNode();
                    prefsNode.putBoolean("warnUnsupportedSCM", false);
                    try {
                        prefsNode.flush();
                    }
                    catch (BackingStoreException e) {
                        CollaboratorUI.log((String)"Could not save 'Don't warn of unsupported SCMs' preference", (Throwable)e);
                    }
                }
                foundUnsupportedSCM = true;
            }
            catch (ScmConfigurationException e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                CollaboratorUI.openError((Shell)shell, (String)"Configuration Problem", (Throwable)e, (boolean)true, (boolean)true);
                return null;
            }
        }
        return super.execute(event);
    }

    @Override
    protected IChangesSelectionPage getChangesSelectionPage(ExecutionEvent event) throws ExecutionException {
        return new WorkspaceChangesSelectionPage((IResourceScmClientConfiguration)this.clientConfigManager, this.selectionResources);
    }
}

