/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.ide.actions;

import com.smartbear.collaborator.ui.ide.CollaboratorIDEUI;
import com.smartbear.util.NumberUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenReviewHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Throwable error;
        String reviewIdStr = event.getParameter("com.smartbear.collaborator.ui.commands.OpenReview_ReviewId");
        if (reviewIdStr == null) {
            throw new ExecutionException("No reviewId parameter supplied to 'open review' command");
        }
        int reviewId = NumberUtils.parseInteger((String)reviewIdStr, (int)-1);
        if (reviewId < 0) {
            throw new ExecutionException("Invalid reviewId parameter supplied to 'open review' command: '" + reviewIdStr + "'");
        }
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window == null) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        if ((error = CollaboratorIDEUI.openReview(window, reviewId)) != null) {
            throw new ExecutionException("Error opening Review " + reviewId, error);
        }
        return null;
    }
}

