/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.ide.jobs;

import com.smartbear.ccollab.client.CollabClientServerConnectivityException;
import com.smartbear.ccollab.datamodel.client.IClientActionItem;
import com.smartbear.ccollab.datamodel.client.IClientAtomicChangelist;
import com.smartbear.ccollab.datamodel.client.IClientScmMaterials;
import com.smartbear.ccollab.datamodel.client.impl.DMClientActionItem;
import com.smartbear.collaborator.JsonAPIHandler;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.jobs.AbstractActionItemsRefreshJob;
import com.smartbear.collaborator.preferences.PrefsHelper;
import com.smartbear.collaborator.resources.DefectMarkerUtils;
import com.smartbear.collaborator.resources.ResourcesUtil;
import com.smartbear.collaborator.ui.ide.views.ActionItemsView;
import com.smartbear.collections.ClosureReturn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ClientActionItemsRefreshJob
extends AbstractActionItemsRefreshJob<DMClientActionItem> {
    public static final ClientActionItemsRefreshJob INSTANCE = new ClientActionItemsRefreshJob();

    private ClientActionItemsRefreshJob() {
        if (PrefsHelper.getPrefs().shouldDecorateWorkspaceFiles()) {
            this.start();
        }
        PrefsHelper.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (ClientActionItemsRefreshJob.this.shouldReschedule()) {
                    ClientActionItemsRefreshJob.this.start();
                } else {
                    ClientActionItemsRefreshJob.this.stop();
                }
            }
        });
    }

    protected List<DMClientActionItem> loadActionItems() throws CollabClientServerConnectivityException {
        try {
            return JsonAPIHandler.getClientActionItems((String)PrefsHelper.getPrefs().getClientGuid());
        }
        catch (CollabClientException e) {
            throw new CollabClientServerConnectivityException(CollabClientServerConnectivityException.ConnectionErrorType.getErrorTypeByException((Exception)((Object)e), (CollabClientServerConnectivityException.ConnectionErrorType)CollabClientServerConnectivityException.ConnectionErrorType.JSON_CLIENT_SERVER), e.getMessage());
        }
    }

    protected IStatus doRun(IProgressMonitor monitor) throws CollabClientServerConnectivityException {
        IStatus status = super.doRun((IProgressMonitor)new NullProgressMonitor());
        if (!status.isOK()) {
            return status;
        }
        if (PrefsHelper.getPrefs().shouldDecorateWorkspaceFiles()) {
            this.updateDecoratorsAndMarkers(this.getActionItems(), monitor);
        }
        return status;
    }

    private void updateDecoratorsAndMarkers(List<DMClientActionItem> actionItems, IProgressMonitor monitor) {
        ArrayList files = new ArrayList();
        for (IClientActionItem iClientActionItem : actionItems) {
            for (IClientScmMaterials scmMaterials : iClientActionItem.getClientScmMaterials()) {
                files.addAll(scmMaterials.getClientFiles());
                for (IClientAtomicChangelist changelist : scmMaterials.getClientAtomicChangelists()) {
                    files.addAll(changelist.getClientFiles());
                }
            }
        }
        DefectMarkerUtils.updateDefectMarkers(files, (IProgressMonitor)monitor);
        ResourcesUtil.updateResourceProperties(files);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().getDecoratorManager().update("com.smartbear.collaborator.ui.ide.reviewdecorator");
            }
        });
    }

    public boolean shouldReschedule() {
        if (PrefsHelper.getPrefs().shouldDecorateWorkspaceFiles()) {
            return true;
        }
        final ClosureReturn viewVisible = ClosureReturn.create();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                viewVisible.set((Object)ActionItemsView.isVisible());
            }
        });
        return (Boolean)viewVisible.get();
    }

    public void stop() {
        super.stop();
        this.updateDecoratorsAndMarkers(Collections.emptyList(), (IProgressMonitor)new NullProgressMonitor());
    }
}

