/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.ide.jobs;

import com.smartbear.collaborator.jobs.AddToReviewJob;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewInfo;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ide.jobs.ClientActionItemsRefreshJob;
import com.smartbear.collaborator.ui.util.PlatformUIUtils;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;

public class ReviewFinishedHandler
extends JobChangeAdapter {
    public void done(IJobChangeEvent e) {
        IJobChangeEvent event = e;
        IStatus status = event.getResult();
        if (status.getSeverity() != 4) {
            ClientActionItemsRefreshJob.INSTANCE.start();
            AddToReviewJob job = (AddToReviewJob)event.getJob();
            ReviewInfo reviewInfo = job.getReviewInfo();
            final int reviewId = reviewInfo.getReviewId();
            final String reviewDisplayText = reviewInfo.getDisplayText();
            final List<Integer> selection = Collections.singletonList(reviewId);
            if (!status.isOK()) {
                StringBuilder message = new StringBuilder(status.getMessage());
                IStatus[] childStatuses = null;
                if (status.isMultiStatus() && (childStatuses = status.getChildren()).length > 0) {
                    for (IStatus childStatus : childStatuses) {
                        message.append("\n");
                        message.append(childStatus.getMessage());
                    }
                }
                CollaboratorUI.openWarning((Shell)CollaboratorUI.getShell(), (String)message.toString());
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlatformUIUtils.executeCommand((IServiceLocator)PlatformUI.getWorkbench(), (String)"com.smartbear.collaborator.ui.commands.OpenReview", Collections.singletonMap("com.smartbear.collaborator.ui.commands.OpenReview_ReviewId", reviewId), (List)selection);
                    }
                    catch (ExecutionException ex) {
                        CollaboratorUI.openError((Shell)CollaboratorUI.getShell(), (String)("Error opening " + reviewDisplayText), (Throwable)ex, (boolean)false, (boolean)true);
                    }
                }
            });
        }
    }
}

