/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.ide.preferences;

import com.smartbear.ccollab.datamodel.ILargeObjectStore;
import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.debug.DebugWindow;
import com.smartbear.collaborator.ui.preferences.FileHistoryDepthFieldEditor;
import com.smartbear.collaborator.ui.preferences.RefreshIntervalFieldEditor;
import com.smartbear.util.Strings;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class IDEPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.smartbear.collaborator.ui.ide.preferences.IDEPreferencePage";
    private Label cacheLabel;
    private Button clearCacheButton;
    private Button captureDebuggingLogButton;
    private DebugWindowCaptureButtonLinkDisposer captureLogButtonLinkDisposer;

    public IDEPreferencePage() {
        super(1);
        this.setTitle(Product.current.getProductName());
    }

    public IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.smartbear.collaborator");
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        BooleanFieldEditor decorateWorkspaceFiles = new BooleanFieldEditor("backgroundRefresh", "Decorate workspace files under Review", this.getFieldEditorParent());
        this.addField((FieldEditor)decorateWorkspaceFiles);
        RefreshIntervalFieldEditor refreshIntervalEditor = new RefreshIntervalFieldEditor(this.getFieldEditorParent());
        this.addField((FieldEditor)refreshIntervalEditor);
        RadioGroupFieldEditor switchPerspective = new RadioGroupFieldEditor("switchPerspective", "Open the Collaborator perspective when opening a review", 3, (String[][])new String[][]{{"Prompt", "prompt"}, {"Always", "always"}, {"Never", "never"}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)switchPerspective);
        BooleanFieldEditor warnUnsupportedSCM = new BooleanFieldEditor("warnUnsupportedSCM", "Warn if SCM system is unsupported", this.getFieldEditorParent());
        this.addField((FieldEditor)warnUnsupportedSCM);
        BooleanFieldEditor reviewInEclipse = new BooleanFieldEditor("reviewInEclipse", "Open Reviews in Eclipse Editor", this.getFieldEditorParent());
        this.addField((FieldEditor)reviewInEclipse);
        FileHistoryDepthFieldEditor fileHistoryEditor = new FileHistoryDepthFieldEditor(this.getFieldEditorParent());
        this.addField((FieldEditor)fileHistoryEditor);
        BooleanFieldEditor ignoreWhitespaceInEclipseEditor = new BooleanFieldEditor("ignoreWhitespaceInEclipseEditor", "Ignore White Space in Eclipse Editor", this.getFieldEditorParent());
        this.addField((FieldEditor)ignoreWhitespaceInEclipseEditor);
        BooleanFieldEditor ignoreSequenceNumberInEclipseEditor = new BooleanFieldEditor("ignoreSequenceNumberInEclipseEditor", "Ignore Sequence Number in Eclipse Editor", this.getFieldEditorParent());
        this.addField((FieldEditor)ignoreSequenceNumberInEclipseEditor);
    }

    private void updateCacheLabelAndButton() {
        ILargeObjectStore.IObjectSummary summary;
        try {
            summary = Collaborator.getContentManager().getCacheSummaryEstimate();
        }
        catch (IOException e) {
            CollaboratorUI.log((String)"Error loading content cache", (Throwable)e);
            if (this.cacheLabel != null) {
                this.cacheLabel.setText("File Content Cache: <error - see log>");
            }
            if (this.clearCacheButton != null) {
                this.clearCacheButton.setEnabled(false);
            }
            return;
        }
        if (this.cacheLabel != null) {
            this.cacheLabel.setText("File Content Cache: " + (summary.isEstimate() ? "~" : "") + summary.getNumObjects() + " files, " + (summary.isEstimate() ? "~" : "") + Strings.byteCountToDisplaySize((long)summary.getTotalBytes()));
        }
        if (this.clearCacheButton != null) {
            this.clearCacheButton.setEnabled(summary.getNumObjects() > 0 || summary.getTotalBytes() > 0L);
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        this.cacheLabel = new Label(composite, 0);
        this.cacheLabel.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.clearCacheButton = new Button(composite, 8);
        this.clearCacheButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.clearCacheButton.setText("Clear");
        this.updateCacheLabelAndButton();
        this.clearCacheButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(IDEPreferencePage.this.getShell());
                dialog.setOpenOnRun(true);
                dialog.setCancelable(false);
                try {
                    dialog.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                Collaborator.getContentManager().clearCache(monitor);
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException ex) {
                    CollaboratorUI.log((String)"Error clearing file content cache", (Throwable)ex);
                }
                catch (InterruptedException ex) {
                    CollaboratorUI.log((String)"Error clearing file content cache", (Throwable)ex);
                }
                IDEPreferencePage.this.updateCacheLabelAndButton();
            }
        });
        this.captureDebuggingLogButton = new Button(composite, 8);
        this.captureDebuggingLogButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.captureDebuggingLogButton.setText("Capture Debugging Log");
        this.linkCaptureDebugButtonToWindow(CollaboratorUI.getDebugWindow());
        this.captureDebuggingLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugWindow debugWindow = CollaboratorUI.createDebugWindow((Shell)IDEPreferencePage.this.getShell());
                debugWindow.open();
                Rectangle parentDisplaySize = Display.getDefault().getClientArea();
                Shell shell = debugWindow.getShell();
                if (shell != null) {
                    shell.setSize(shell.getSize().x, parentDisplaySize.height / 2);
                }
                IDEPreferencePage.this.linkCaptureDebugButtonToWindow(debugWindow);
            }
        });
        this.captureDebuggingLogButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DebugWindow debugWindow = CollaboratorUI.getDebugWindow();
                if (IDEPreferencePage.this.captureLogButtonLinkDisposer != null && debugWindow != null && debugWindow.getShell() != null && !debugWindow.getShell().isDisposed()) {
                    debugWindow.getShell().removeShellListener((ShellListener)IDEPreferencePage.this.captureLogButtonLinkDisposer);
                }
                IDEPreferencePage.this.captureLogButtonLinkDisposer = null;
            }
        });
        return composite;
    }

    private void linkCaptureDebugButtonToWindow(DebugWindow window) {
        if (window == null) {
            return;
        }
        this.captureDebuggingLogButton.setEnabled(!window.isLogging());
        if (window.getShell() != null) {
            if (this.captureLogButtonLinkDisposer != null) {
                window.getShell().removeShellListener((ShellListener)this.captureLogButtonLinkDisposer);
            }
            this.captureLogButtonLinkDisposer = new DebugWindowCaptureButtonLinkDisposer(this.captureDebuggingLogButton);
            window.getShell().addShellListener((ShellListener)this.captureLogButtonLinkDisposer);
        }
    }

    private static class DebugWindowCaptureButtonLinkDisposer
    extends ShellAdapter {
        private WeakReference<Button> captureButtonRef;

        public DebugWindowCaptureButtonLinkDisposer(Button captureButton) {
            this.captureButtonRef = new WeakReference<Button>(captureButton);
        }

        public void shellClosed(ShellEvent event) {
            Button button = (Button)this.captureButtonRef.get();
            if (button != null && !button.isDisposed()) {
                button.setEnabled(true);
            }
        }
    }
}

